/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.custom;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.mindee.parsing.SummaryHelper;
import com.mindee.parsing.custom.ClassificationField;
import com.mindee.parsing.custom.CustomV1DocumentPredictionDeserializer;
import com.mindee.parsing.custom.ListField;
import java.util.Map;
import java.util.TreeMap;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=CustomV1DocumentPredictionDeserializer.class)
public class CustomV1DocumentPrediction {
    private Map<String, ClassificationField> classificationFields;
    private Map<String, ListField> fields;

    public String toString() {
        TreeMap<String, ListField> sorted = new TreeMap<String, ListField>(this.fields);
        StringBuilder summary = new StringBuilder();
        for (Map.Entry<String, ClassificationField> entry : this.classificationFields.entrySet()) {
            summary.append(String.format(":%s: %s%n", entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : sorted.entrySet()) {
            summary.append(String.format(":%s: %s%n", entry.getKey(), entry.getValue()));
        }
        return SummaryHelper.cleanSummary(summary.toString());
    }

    public CustomV1DocumentPrediction(Map<String, ClassificationField> classificationFields, Map<String, ListField> fields) {
        this.classificationFields = classificationFields;
        this.fields = fields;
    }

    public Map<String, ClassificationField> getClassificationFields() {
        return this.classificationFields;
    }

    public Map<String, ListField> getFields() {
        return this.fields;
    }
}

