/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.custom;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mindee.parsing.custom.ListFieldValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ListField {
    @JsonProperty(value="confidence")
    private double confidence;
    @JsonProperty(value="values")
    private List<ListFieldValue> values;

    public ListField() {
        this.values = new ArrayList<ListFieldValue>();
    }

    public ListField(double confidence, List<ListFieldValue> values) {
        this.confidence = confidence;
        this.values = values;
    }

    public String toString() {
        return String.format("%s", this.values.stream().map(ListFieldValue::toString).collect(Collectors.joining(" ")));
    }

    public double getConfidence() {
        return this.confidence;
    }

    public List<ListFieldValue> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListField)) {
            return false;
        }
        ListField other = (ListField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getConfidence(), other.getConfidence()) != 0) {
            return false;
        }
        List<ListFieldValue> this$values = this.getValues();
        List<ListFieldValue> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $confidence = Double.doubleToLongBits(this.getConfidence());
        result = result * 59 + (int)($confidence >>> 32 ^ $confidence);
        List<ListFieldValue> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }
}

