/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.custom;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.mindee.geometry.Polygon;
import com.mindee.geometry.PolygonDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ListFieldValue {
    @JsonProperty(value="confidence")
    private double confidence;
    @JsonProperty(value="polygon")
    @JsonDeserialize(using=PolygonDeserializer.class)
    private Polygon polygon;
    @JsonProperty(value="content")
    private String content;

    public ListFieldValue() {
    }

    public ListFieldValue(String content, double confidence, Polygon polygon) {
        this.confidence = confidence;
        this.polygon = polygon;
        this.content = content;
    }

    public String toString() {
        return this.content == null ? "" : this.content;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public String getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListFieldValue)) {
            return false;
        }
        ListFieldValue other = (ListFieldValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getConfidence(), other.getConfidence()) != 0) {
            return false;
        }
        Polygon this$polygon = this.getPolygon();
        Polygon other$polygon = other.getPolygon();
        if (this$polygon == null ? other$polygon != null : !this$polygon.equals(other$polygon)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListFieldValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $confidence = Double.doubleToLongBits(this.getConfidence());
        result = result * 59 + (int)($confidence >>> 32 ^ $confidence);
        Polygon $polygon = this.getPolygon();
        result = result * 59 + ($polygon == null ? 43 : $polygon.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }
}

