/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.custom.lineitems;

import com.mindee.geometry.Bbox;
import com.mindee.geometry.BoundingBoxUtils;
import com.mindee.geometry.Polygon;
import com.mindee.geometry.PolygonUtils;
import com.mindee.parsing.common.field.StringField;
import com.mindee.parsing.custom.ListFieldValue;
import java.util.HashMap;
import java.util.Map;

public class Line {
    private final Integer rowNumber;
    private final Map<String, StringField> fields;
    private Bbox bbox;
    private final Double heightTolerance;

    public Line(Integer rowNumber, Map<String, StringField> fields) {
        this.rowNumber = rowNumber;
        this.fields = fields;
        this.heightTolerance = 0.0;
    }

    public Line(Integer rowNumber, Double heightTolerance) {
        this.rowNumber = rowNumber;
        this.fields = new HashMap<String, StringField>();
        this.heightTolerance = heightTolerance;
    }

    public void addField(String name, ListFieldValue fieldValue) {
        if (this.fields.containsKey(name)) {
            StringField existingField = this.fields.get(name);
            Polygon mergedPolygon = PolygonUtils.combine(BoundingBoxUtils.createBoundingBoxFrom(existingField.getPolygon()), BoundingBoxUtils.createBoundingBoxFrom(fieldValue.getPolygon()));
            String content = existingField.getValue() == null ? fieldValue.getContent() : String.join((CharSequence)" ", existingField.getValue(), fieldValue.getContent());
            this.fields.replace(name, new StringField(content, existingField.getConfidence() * fieldValue.getConfidence(), mergedPolygon));
        } else {
            this.fields.put(name, new StringField(fieldValue.getContent(), fieldValue.getConfidence(), fieldValue.getPolygon()));
        }
    }

    public void setBbox(Bbox bbox) {
        this.bbox = bbox;
    }

    public Integer getRowNumber() {
        return this.rowNumber;
    }

    public Map<String, StringField> getFields() {
        return this.fields;
    }

    public Bbox getBbox() {
        return this.bbox;
    }

    public Double getHeightTolerance() {
        return this.heightTolerance;
    }
}

