/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.custom.lineitems;

import com.mindee.geometry.Bbox;
import com.mindee.geometry.BboxUtils;
import com.mindee.parsing.custom.ListField;
import com.mindee.parsing.custom.ListFieldValue;
import com.mindee.parsing.custom.lineitems.Anchor;
import com.mindee.parsing.custom.lineitems.Line;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.util.Precision;

public final class LineGenerator {
    private LineGenerator() {
    }

    public static Collection<Line> prepareLines(Map<String, ListField> fields, Anchor fieldAsAnchor) {
        HashMap<Integer, Line> table = new HashMap<Integer, Line>();
        ListField anchor = fields.get(fieldAsAnchor.getName());
        if (anchor == null) {
            throw new IllegalStateException("The field selected for the anchor was not found.");
        }
        if (anchor.getValues().isEmpty()) {
            throw new IllegalStateException("No lines have been detected.");
        }
        int lineNumber = 1;
        Line currentLine = new Line((Integer)lineNumber, fieldAsAnchor.getTolerance());
        ListFieldValue currentValue = anchor.getValues().get(0);
        currentLine.setBbox(BboxUtils.generate(currentValue.getPolygon()));
        for (int i = 1; i < anchor.getValues().size(); ++i) {
            currentValue = anchor.getValues().get(i);
            Bbox currentFieldBbox = BboxUtils.generate(currentValue.getPolygon());
            if (Precision.equals((double)currentLine.getBbox().getMinY(), (double)currentFieldBbox.getMinY(), (double)fieldAsAnchor.getTolerance())) {
                currentLine.setBbox(BboxUtils.merge(Arrays.asList(currentLine.getBbox(), currentFieldBbox)));
                continue;
            }
            table.put(lineNumber, currentLine);
            currentLine = new Line((Integer)(++lineNumber), fieldAsAnchor.getTolerance());
            currentLine.setBbox(currentFieldBbox);
        }
        table.putIfAbsent(lineNumber, currentLine);
        return table.values();
    }
}

