/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.custom.lineitems;

import com.mindee.geometry.PolygonUtils;
import com.mindee.parsing.custom.ListField;
import com.mindee.parsing.custom.ListFieldValue;
import com.mindee.parsing.custom.lineitems.Anchor;
import com.mindee.parsing.custom.lineitems.Line;
import com.mindee.parsing.custom.lineitems.LineGenerator;
import com.mindee.parsing.custom.lineitems.LineItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class LineItemsGenerator {
    private LineItemsGenerator() {
    }

    public static LineItems generate(List<String> fieldNames, Map<String, ListField> fields, Anchor anchor) {
        Map<String, ListField> fieldsToTransformIntoLines = fields.entrySet().stream().filter(field -> fieldNames.contains(field.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<Line> lines = LineItemsGenerator.populateLines(fieldsToTransformIntoLines, new ArrayList<Line>(LineGenerator.prepareLines(fieldsToTransformIntoLines, anchor)));
        return new LineItems(lines);
    }

    private static List<Line> populateLines(Map<String, ListField> fields, List<Line> lines) {
        ArrayList<Line> populatedLines = new ArrayList<Line>();
        for (Line currentLine : lines) {
            for (Map.Entry<String, ListField> field : fields.entrySet()) {
                for (ListFieldValue listFieldValue : field.getValue().getValues()) {
                    double minYCurrentValue = PolygonUtils.getMinYCoordinate(listFieldValue.getPolygon());
                    if (!(minYCurrentValue < currentLine.getBbox().getMaxY()) || !(minYCurrentValue >= currentLine.getBbox().getMinY())) continue;
                    currentLine.addField(field.getKey(), listFieldValue);
                }
            }
            populatedLines.add(currentLine);
        }
        return populatedLines;
    }
}

