/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.financial;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mindee.parsing.SummaryHelper;
import com.mindee.parsing.common.field.AmountField;
import com.mindee.parsing.common.field.CompanyRegistrationField;
import com.mindee.parsing.common.field.DateField;
import com.mindee.parsing.common.field.DocumentTypeField;
import com.mindee.parsing.common.field.LocaleField;
import com.mindee.parsing.common.field.PaymentDetailsField;
import com.mindee.parsing.common.field.StringField;
import com.mindee.parsing.common.field.TaxField;
import com.mindee.parsing.invoice.InvoiceLineItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FinancialV1DocumentPrediction {
    @JsonProperty(value="locale")
    private LocaleField locale;
    @JsonProperty(value="document_type")
    private DocumentTypeField documentType;
    @JsonProperty(value="date")
    private DateField date;
    @JsonProperty(value="invoice_number")
    private StringField invoiceNumber;
    @JsonProperty(value="reference_numbers")
    private List<StringField> referenceNumbers = new ArrayList<StringField>();
    @JsonProperty(value="due_date")
    private DateField dueDate;
    @JsonProperty(value="supplier_name")
    private StringField supplierName;
    @JsonProperty(value="supplier_company_registrations")
    private List<CompanyRegistrationField> supplierCompanyRegistrations = new ArrayList<CompanyRegistrationField>();
    @JsonProperty(value="supplier_address")
    private StringField supplierAddress;
    @JsonProperty(value="customer_name")
    private StringField customerName;
    @JsonProperty(value="customer_company_registrations")
    private List<CompanyRegistrationField> customerCompanyRegistrations = new ArrayList<CompanyRegistrationField>();
    @JsonProperty(value="customer_address")
    private StringField customerAddress;
    @JsonProperty(value="supplier_payment_details")
    private List<PaymentDetailsField> paymentDetails = new ArrayList<PaymentDetailsField>();
    @JsonProperty(value="taxes")
    private List<TaxField> taxes;
    @JsonProperty(value="total_amount")
    private AmountField totalAmount;
    @JsonProperty(value="total_net")
    private AmountField totalNet;
    @JsonProperty(value="time")
    private StringField time;
    @JsonProperty(value="category")
    private StringField category;
    @JsonProperty(value="subcategory")
    private StringField subCategory;
    @JsonProperty(value="total_tax")
    private AmountField totalTax;
    @JsonProperty(value="tip")
    private AmountField tip;
    @JsonProperty(value="line_items")
    private List<InvoiceLineItem> lineItems = new ArrayList<InvoiceLineItem>();

    public String toString() {
        String lineItemsSummary = "";
        if (!this.getLineItems().isEmpty()) {
            lineItemsSummary = String.format("%n====================== ======== ========= ========== ================== ====================================%n", new Object[0]) + String.format("Code                   QTY      Price     Amount     Tax (Rate)         Description%n", new Object[0]) + String.format("====================== ======== ========= ========== ================== ====================================%n", new Object[0]);
            lineItemsSummary = lineItemsSummary + this.getLineItems().stream().map(InvoiceLineItem::toString).collect(Collectors.joining(String.format("%n", new Object[0])));
            lineItemsSummary = lineItemsSummary + String.format("%n====================== ======== ========= ========== ================== ====================================", new Object[0]);
        }
        String summary = String.format(":Document type: %s%n", this.getDocumentType()) + String.format(":Category: %s%n", this.getCategory()) + String.format(":Subcategory: %s%n", this.getSubCategory()) + String.format(":Locale: %s%n", this.getLocale()) + String.format(":Date: %s%n", this.getDate()) + String.format(":Due date: %s%n", this.getDueDate()) + String.format(":Time: %s%n", this.getTime()) + String.format(":Number: %s%n", this.getInvoiceNumber()) + String.format(":Reference numbers: %s%n", this.getReferenceNumbers().stream().map(StringField::toString).collect(Collectors.joining(", "))) + String.format(":Supplier name: %s%n", this.getSupplierName()) + String.format(":Supplier address: %s%n", this.getSupplierAddress()) + String.format(":Supplier company registrations: %s%n", this.getSupplierCompanyRegistrations().stream().map(CompanyRegistrationField::getValue).collect(Collectors.joining("; "))) + String.format(":Supplier payment details: %s%n", this.getPaymentDetails().stream().map(PaymentDetailsField::toString).collect(Collectors.joining("%n                 "))) + String.format(":Customer name: %s%n", this.getCustomerName()) + String.format(":Customer address: %s%n", this.getCustomerAddress()) + String.format(":Customer company registrations: %s%n", this.getCustomerCompanyRegistrations().stream().map(CompanyRegistrationField::getValue).collect(Collectors.joining("; "))) + String.format(":Tip: %s%n", this.getTip()) + String.format(":Taxes: %s%n", this.getTaxes().stream().map(TaxField::toString).collect(Collectors.joining("%n       "))) + String.format(":Total taxes: %s%n", this.getTotalTax()) + String.format(":Total net: %s%n", this.getTotalNet()) + String.format(":Total amount: %s%n%n", this.getTotalAmount()) + String.format(":Line Items: %s%n", lineItemsSummary);
        return SummaryHelper.cleanSummary(summary);
    }

    public LocaleField getLocale() {
        return this.locale;
    }

    public DocumentTypeField getDocumentType() {
        return this.documentType;
    }

    public DateField getDate() {
        return this.date;
    }

    public StringField getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public List<StringField> getReferenceNumbers() {
        return this.referenceNumbers;
    }

    public DateField getDueDate() {
        return this.dueDate;
    }

    public StringField getSupplierName() {
        return this.supplierName;
    }

    public List<CompanyRegistrationField> getSupplierCompanyRegistrations() {
        return this.supplierCompanyRegistrations;
    }

    public StringField getSupplierAddress() {
        return this.supplierAddress;
    }

    public StringField getCustomerName() {
        return this.customerName;
    }

    public List<CompanyRegistrationField> getCustomerCompanyRegistrations() {
        return this.customerCompanyRegistrations;
    }

    public StringField getCustomerAddress() {
        return this.customerAddress;
    }

    public List<PaymentDetailsField> getPaymentDetails() {
        return this.paymentDetails;
    }

    public List<TaxField> getTaxes() {
        return this.taxes;
    }

    public AmountField getTotalAmount() {
        return this.totalAmount;
    }

    public AmountField getTotalNet() {
        return this.totalNet;
    }

    public StringField getTime() {
        return this.time;
    }

    public StringField getCategory() {
        return this.category;
    }

    public StringField getSubCategory() {
        return this.subCategory;
    }

    public AmountField getTotalTax() {
        return this.totalTax;
    }

    public AmountField getTip() {
        return this.tip;
    }

    public List<InvoiceLineItem> getLineItems() {
        return this.lineItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinancialV1DocumentPrediction)) {
            return false;
        }
        FinancialV1DocumentPrediction other = (FinancialV1DocumentPrediction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocaleField this$locale = this.getLocale();
        LocaleField other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        DocumentTypeField this$documentType = this.getDocumentType();
        DocumentTypeField other$documentType = other.getDocumentType();
        if (this$documentType == null ? other$documentType != null : !this$documentType.equals(other$documentType)) {
            return false;
        }
        DateField this$date = this.getDate();
        DateField other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        StringField this$invoiceNumber = this.getInvoiceNumber();
        StringField other$invoiceNumber = other.getInvoiceNumber();
        if (this$invoiceNumber == null ? other$invoiceNumber != null : !this$invoiceNumber.equals(other$invoiceNumber)) {
            return false;
        }
        List<StringField> this$referenceNumbers = this.getReferenceNumbers();
        List<StringField> other$referenceNumbers = other.getReferenceNumbers();
        if (this$referenceNumbers == null ? other$referenceNumbers != null : !((Object)this$referenceNumbers).equals(other$referenceNumbers)) {
            return false;
        }
        DateField this$dueDate = this.getDueDate();
        DateField other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !this$dueDate.equals(other$dueDate)) {
            return false;
        }
        StringField this$supplierName = this.getSupplierName();
        StringField other$supplierName = other.getSupplierName();
        if (this$supplierName == null ? other$supplierName != null : !this$supplierName.equals(other$supplierName)) {
            return false;
        }
        List<CompanyRegistrationField> this$supplierCompanyRegistrations = this.getSupplierCompanyRegistrations();
        List<CompanyRegistrationField> other$supplierCompanyRegistrations = other.getSupplierCompanyRegistrations();
        if (this$supplierCompanyRegistrations == null ? other$supplierCompanyRegistrations != null : !((Object)this$supplierCompanyRegistrations).equals(other$supplierCompanyRegistrations)) {
            return false;
        }
        StringField this$supplierAddress = this.getSupplierAddress();
        StringField other$supplierAddress = other.getSupplierAddress();
        if (this$supplierAddress == null ? other$supplierAddress != null : !this$supplierAddress.equals(other$supplierAddress)) {
            return false;
        }
        StringField this$customerName = this.getCustomerName();
        StringField other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        List<CompanyRegistrationField> this$customerCompanyRegistrations = this.getCustomerCompanyRegistrations();
        List<CompanyRegistrationField> other$customerCompanyRegistrations = other.getCustomerCompanyRegistrations();
        if (this$customerCompanyRegistrations == null ? other$customerCompanyRegistrations != null : !((Object)this$customerCompanyRegistrations).equals(other$customerCompanyRegistrations)) {
            return false;
        }
        StringField this$customerAddress = this.getCustomerAddress();
        StringField other$customerAddress = other.getCustomerAddress();
        if (this$customerAddress == null ? other$customerAddress != null : !this$customerAddress.equals(other$customerAddress)) {
            return false;
        }
        List<PaymentDetailsField> this$paymentDetails = this.getPaymentDetails();
        List<PaymentDetailsField> other$paymentDetails = other.getPaymentDetails();
        if (this$paymentDetails == null ? other$paymentDetails != null : !((Object)this$paymentDetails).equals(other$paymentDetails)) {
            return false;
        }
        List<TaxField> this$taxes = this.getTaxes();
        List<TaxField> other$taxes = other.getTaxes();
        if (this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes)) {
            return false;
        }
        AmountField this$totalAmount = this.getTotalAmount();
        AmountField other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !this$totalAmount.equals(other$totalAmount)) {
            return false;
        }
        AmountField this$totalNet = this.getTotalNet();
        AmountField other$totalNet = other.getTotalNet();
        if (this$totalNet == null ? other$totalNet != null : !this$totalNet.equals(other$totalNet)) {
            return false;
        }
        StringField this$time = this.getTime();
        StringField other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        StringField this$category = this.getCategory();
        StringField other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        StringField this$subCategory = this.getSubCategory();
        StringField other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        AmountField this$totalTax = this.getTotalTax();
        AmountField other$totalTax = other.getTotalTax();
        if (this$totalTax == null ? other$totalTax != null : !this$totalTax.equals(other$totalTax)) {
            return false;
        }
        AmountField this$tip = this.getTip();
        AmountField other$tip = other.getTip();
        if (this$tip == null ? other$tip != null : !this$tip.equals(other$tip)) {
            return false;
        }
        List<InvoiceLineItem> this$lineItems = this.getLineItems();
        List<InvoiceLineItem> other$lineItems = other.getLineItems();
        return !(this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FinancialV1DocumentPrediction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocaleField $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        DocumentTypeField $documentType = this.getDocumentType();
        result = result * 59 + ($documentType == null ? 43 : $documentType.hashCode());
        DateField $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        StringField $invoiceNumber = this.getInvoiceNumber();
        result = result * 59 + ($invoiceNumber == null ? 43 : $invoiceNumber.hashCode());
        List<StringField> $referenceNumbers = this.getReferenceNumbers();
        result = result * 59 + ($referenceNumbers == null ? 43 : ((Object)$referenceNumbers).hashCode());
        DateField $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : $dueDate.hashCode());
        StringField $supplierName = this.getSupplierName();
        result = result * 59 + ($supplierName == null ? 43 : $supplierName.hashCode());
        List<CompanyRegistrationField> $supplierCompanyRegistrations = this.getSupplierCompanyRegistrations();
        result = result * 59 + ($supplierCompanyRegistrations == null ? 43 : ((Object)$supplierCompanyRegistrations).hashCode());
        StringField $supplierAddress = this.getSupplierAddress();
        result = result * 59 + ($supplierAddress == null ? 43 : $supplierAddress.hashCode());
        StringField $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        List<CompanyRegistrationField> $customerCompanyRegistrations = this.getCustomerCompanyRegistrations();
        result = result * 59 + ($customerCompanyRegistrations == null ? 43 : ((Object)$customerCompanyRegistrations).hashCode());
        StringField $customerAddress = this.getCustomerAddress();
        result = result * 59 + ($customerAddress == null ? 43 : $customerAddress.hashCode());
        List<PaymentDetailsField> $paymentDetails = this.getPaymentDetails();
        result = result * 59 + ($paymentDetails == null ? 43 : ((Object)$paymentDetails).hashCode());
        List<TaxField> $taxes = this.getTaxes();
        result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
        AmountField $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : $totalAmount.hashCode());
        AmountField $totalNet = this.getTotalNet();
        result = result * 59 + ($totalNet == null ? 43 : $totalNet.hashCode());
        StringField $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        StringField $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        StringField $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        AmountField $totalTax = this.getTotalTax();
        result = result * 59 + ($totalTax == null ? 43 : $totalTax.hashCode());
        AmountField $tip = this.getTip();
        result = result * 59 + ($tip == null ? 43 : $tip.hashCode());
        List<InvoiceLineItem> $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        return result;
    }
}

