/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.invoice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mindee.geometry.Polygon;
import com.mindee.geometry.PolygonDeserializer;
import com.mindee.parsing.SummaryHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InvoiceLineItemBuilderImpl.class)
public class InvoiceLineItem {
    @JsonProperty(value="product_code")
    private final String productCode;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="quantity")
    private final Double quantity;
    @JsonProperty(value="unit_price")
    private final Double unitPrice;
    @JsonProperty(value="total_amount")
    private final Double totalAmount;
    @JsonProperty(value="tax_rate")
    private final Double taxRate;
    @JsonProperty(value="tax_amount")
    private final Double taxAmount;
    @JsonProperty(value="confidence")
    private final Double confidence;
    @JsonProperty(value="page_id")
    private final Double pageId;
    @JsonProperty(value="polygon")
    @JsonDeserialize(using=PolygonDeserializer.class)
    private final Polygon polygon;

    public String toString() {
        String descriptionSummary;
        String productCodeSummary = this.productCode != null ? this.productCode : "";
        String quantitySummary = SummaryHelper.formatAmount(this.quantity);
        String unitPriceSummary = SummaryHelper.formatAmount(this.unitPrice);
        String totalAmountSummary = SummaryHelper.formatAmount(this.totalAmount);
        String tax = SummaryHelper.formatAmount(this.taxAmount);
        tax = tax + (this.taxRate != null ? String.format(" (%s%%)", SummaryHelper.formatAmount(this.taxRate)) : "");
        String string = descriptionSummary = this.description != null ? this.description : "";
        if (descriptionSummary.length() > 33) {
            descriptionSummary = descriptionSummary.substring(0, 33) + "...";
        }
        return String.join((CharSequence)" ", String.format("%-22s", productCodeSummary), String.format("%-8s", quantitySummary), String.format("%-9s", unitPriceSummary), String.format("%-10s", totalAmountSummary), String.format("%-18s", tax), descriptionSummary);
    }

    protected InvoiceLineItem(InvoiceLineItemBuilder<?, ?> b) {
        this.productCode = ((InvoiceLineItemBuilder)b).productCode;
        this.description = ((InvoiceLineItemBuilder)b).description;
        this.quantity = ((InvoiceLineItemBuilder)b).quantity;
        this.unitPrice = ((InvoiceLineItemBuilder)b).unitPrice;
        this.totalAmount = ((InvoiceLineItemBuilder)b).totalAmount;
        this.taxRate = ((InvoiceLineItemBuilder)b).taxRate;
        this.taxAmount = ((InvoiceLineItemBuilder)b).taxAmount;
        this.confidence = ((InvoiceLineItemBuilder)b).confidence;
        this.pageId = ((InvoiceLineItemBuilder)b).pageId;
        this.polygon = ((InvoiceLineItemBuilder)b).polygon;
    }

    public static InvoiceLineItemBuilder<?, ?> builder() {
        return new InvoiceLineItemBuilderImpl();
    }

    public InvoiceLineItemBuilder<?, ?> toBuilder() {
        return new InvoiceLineItemBuilderImpl().$fillValuesFrom(this);
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public Double getTaxRate() {
        return this.taxRate;
    }

    public Double getTaxAmount() {
        return this.taxAmount;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public Double getPageId() {
        return this.pageId;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public InvoiceLineItem(String productCode, String description, Double quantity, Double unitPrice, Double totalAmount, Double taxRate, Double taxAmount, Double confidence, Double pageId, Polygon polygon) {
        this.productCode = productCode;
        this.description = description;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
        this.totalAmount = totalAmount;
        this.taxRate = taxRate;
        this.taxAmount = taxAmount;
        this.confidence = confidence;
        this.pageId = pageId;
        this.polygon = polygon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceLineItem)) {
            return false;
        }
        InvoiceLineItem other = (InvoiceLineItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$quantity = this.getQuantity();
        Double other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Double this$unitPrice = this.getUnitPrice();
        Double other$unitPrice = other.getUnitPrice();
        if (this$unitPrice == null ? other$unitPrice != null : !((Object)this$unitPrice).equals(other$unitPrice)) {
            return false;
        }
        Double this$totalAmount = this.getTotalAmount();
        Double other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        Double this$taxRate = this.getTaxRate();
        Double other$taxRate = other.getTaxRate();
        if (this$taxRate == null ? other$taxRate != null : !((Object)this$taxRate).equals(other$taxRate)) {
            return false;
        }
        Double this$taxAmount = this.getTaxAmount();
        Double other$taxAmount = other.getTaxAmount();
        if (this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount)) {
            return false;
        }
        Double this$confidence = this.getConfidence();
        Double other$confidence = other.getConfidence();
        if (this$confidence == null ? other$confidence != null : !((Object)this$confidence).equals(other$confidence)) {
            return false;
        }
        Double this$pageId = this.getPageId();
        Double other$pageId = other.getPageId();
        if (this$pageId == null ? other$pageId != null : !((Object)this$pageId).equals(other$pageId)) {
            return false;
        }
        String this$productCode = this.getProductCode();
        String other$productCode = other.getProductCode();
        if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Polygon this$polygon = this.getPolygon();
        Polygon other$polygon = other.getPolygon();
        return !(this$polygon == null ? other$polygon != null : !this$polygon.equals(other$polygon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvoiceLineItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Double $unitPrice = this.getUnitPrice();
        result = result * 59 + ($unitPrice == null ? 43 : ((Object)$unitPrice).hashCode());
        Double $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        Double $taxRate = this.getTaxRate();
        result = result * 59 + ($taxRate == null ? 43 : ((Object)$taxRate).hashCode());
        Double $taxAmount = this.getTaxAmount();
        result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
        Double $confidence = this.getConfidence();
        result = result * 59 + ($confidence == null ? 43 : ((Object)$confidence).hashCode());
        Double $pageId = this.getPageId();
        result = result * 59 + ($pageId == null ? 43 : ((Object)$pageId).hashCode());
        String $productCode = this.getProductCode();
        result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Polygon $polygon = this.getPolygon();
        result = result * 59 + ($polygon == null ? 43 : $polygon.hashCode());
        return result;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InvoiceLineItemBuilderImpl
    extends InvoiceLineItemBuilder<InvoiceLineItem, InvoiceLineItemBuilderImpl> {
        private InvoiceLineItemBuilderImpl() {
        }

        @Override
        protected InvoiceLineItemBuilderImpl self() {
            return this;
        }

        @Override
        public InvoiceLineItem build() {
            return new InvoiceLineItem(this);
        }
    }

    public static abstract class InvoiceLineItemBuilder<C extends InvoiceLineItem, B extends InvoiceLineItemBuilder<C, B>> {
        private String productCode;
        private String description;
        private Double quantity;
        private Double unitPrice;
        private Double totalAmount;
        private Double taxRate;
        private Double taxAmount;
        private Double confidence;
        private Double pageId;
        private Polygon polygon;

        protected B $fillValuesFrom(C instance) {
            InvoiceLineItemBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(InvoiceLineItem instance, InvoiceLineItemBuilder<?, ?> b) {
            b.productCode(instance.productCode);
            b.description(instance.description);
            b.quantity(instance.quantity);
            b.unitPrice(instance.unitPrice);
            b.totalAmount(instance.totalAmount);
            b.taxRate(instance.taxRate);
            b.taxAmount(instance.taxAmount);
            b.confidence(instance.confidence);
            b.pageId(instance.pageId);
            b.polygon(instance.polygon);
        }

        @JsonProperty(value="product_code")
        public B productCode(String productCode) {
            this.productCode = productCode;
            return this.self();
        }

        @JsonProperty(value="description")
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @JsonProperty(value="quantity")
        public B quantity(Double quantity) {
            this.quantity = quantity;
            return this.self();
        }

        @JsonProperty(value="unit_price")
        public B unitPrice(Double unitPrice) {
            this.unitPrice = unitPrice;
            return this.self();
        }

        @JsonProperty(value="total_amount")
        public B totalAmount(Double totalAmount) {
            this.totalAmount = totalAmount;
            return this.self();
        }

        @JsonProperty(value="tax_rate")
        public B taxRate(Double taxRate) {
            this.taxRate = taxRate;
            return this.self();
        }

        @JsonProperty(value="tax_amount")
        public B taxAmount(Double taxAmount) {
            this.taxAmount = taxAmount;
            return this.self();
        }

        @JsonProperty(value="confidence")
        public B confidence(Double confidence) {
            this.confidence = confidence;
            return this.self();
        }

        @JsonProperty(value="page_id")
        public B pageId(Double pageId) {
            this.pageId = pageId;
            return this.self();
        }

        @JsonProperty(value="polygon")
        @JsonDeserialize(using=PolygonDeserializer.class)
        public B polygon(Polygon polygon) {
            this.polygon = polygon;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InvoiceLineItem.InvoiceLineItemBuilder(productCode=" + this.productCode + ", description=" + this.description + ", quantity=" + this.quantity + ", unitPrice=" + this.unitPrice + ", totalAmount=" + this.totalAmount + ", taxRate=" + this.taxRate + ", taxAmount=" + this.taxAmount + ", confidence=" + this.confidence + ", pageId=" + this.pageId + ", polygon=" + this.polygon + ")";
        }
    }
}

