/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.invoice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mindee.parsing.SummaryHelper;
import com.mindee.parsing.common.field.AmountField;
import com.mindee.parsing.common.field.CompanyRegistrationField;
import com.mindee.parsing.common.field.DateField;
import com.mindee.parsing.common.field.DocumentTypeField;
import com.mindee.parsing.common.field.LocaleField;
import com.mindee.parsing.common.field.PaymentDetailsField;
import com.mindee.parsing.common.field.StringField;
import com.mindee.parsing.common.field.TaxField;
import com.mindee.parsing.invoice.InvoiceLineItem;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InvoiceV4DocumentPrediction {
    @JsonProperty(value="locale")
    private LocaleField localeField;
    @JsonProperty(value="document_type")
    private DocumentTypeField documentType;
    @JsonProperty(value="date")
    private DateField invoiceDateField;
    @JsonProperty(value="invoice_number")
    private StringField invoiceNumber;
    @JsonProperty(value="reference_numbers")
    private List<StringField> referenceNumbers;
    @JsonProperty(value="due_date")
    private DateField dueDateField;
    @JsonProperty(value="supplier_name")
    private StringField supplierName;
    @JsonProperty(value="supplier_payment_details")
    private List<PaymentDetailsField> supplierPaymentDetails;
    @JsonProperty(value="supplier_company_registrations")
    private List<CompanyRegistrationField> supplierCompanyRegistrations;
    @JsonProperty(value="supplier_address")
    private StringField supplierAddress;
    @JsonProperty(value="customer_name")
    private StringField customerName;
    @JsonProperty(value="customer_company_registrations")
    private List<CompanyRegistrationField> customerCompanyRegistrations;
    @JsonProperty(value="customer_address")
    private StringField customerAddress;
    @JsonProperty(value="taxes")
    private List<TaxField> taxes;
    @JsonProperty(value="total_amount")
    private AmountField totalAmount;
    @JsonProperty(value="total_net")
    private AmountField totalNet;
    @JsonProperty(value="line_items")
    private List<InvoiceLineItem> lineItems;

    public Double getTotalTaxes() {
        return this.taxes.stream().mapToDouble(TaxField::getValue).sum();
    }

    public String toString() {
        String lineItemsSummary = String.format("%n", new Object[0]);
        if (!this.getLineItems().isEmpty()) {
            lineItemsSummary = String.format("%n====================== ======== ========= ========== ================== ====================================%n", new Object[0]) + String.format("Code                   QTY      Price     Amount     Tax (Rate)         Description%n", new Object[0]) + String.format("====================== ======== ========= ========== ================== ====================================%n", new Object[0]);
            lineItemsSummary = lineItemsSummary + this.getLineItems().stream().map(InvoiceLineItem::toString).collect(Collectors.joining(String.format("%n", new Object[0])));
            lineItemsSummary = lineItemsSummary + String.format("%n====================== ======== ========= ========== ================== ====================================", new Object[0]);
        }
        String summary = String.format(":Locale: %s%n", this.getLocaleField()) + String.format(":Document type: %s%n", this.getDocumentType()) + String.format(":Invoice number: %s%n", this.getInvoiceNumber()) + String.format(":Reference numbers: %s%n", this.getReferenceNumbers().stream().map(StringField::toString).collect(Collectors.joining(", "))) + String.format(":Invoice date: %s%n", this.getInvoiceDateField()) + String.format(":Invoice due date: %s%n", this.getDueDateField()) + String.format(":Supplier name: %s%n", this.getSupplierName()) + String.format(":Supplier address: %s%n", this.getSupplierAddress()) + String.format(":Supplier company registrations: %s%n", this.getSupplierCompanyRegistrations().stream().map(CompanyRegistrationField::getValue).collect(Collectors.joining("; "))) + String.format(":Supplier payment details: %s%n", this.getSupplierPaymentDetails().stream().map(PaymentDetailsField::toString).collect(Collectors.joining("%n                 "))) + String.format(":Customer name: %s%n", this.getCustomerName()) + String.format(":Customer address: %s%n", this.getCustomerAddress()) + String.format(":Customer company registrations: %s%n", this.getCustomerCompanyRegistrations().stream().map(CompanyRegistrationField::getValue).collect(Collectors.joining("; "))) + String.format(":Taxes: %s%n", this.getTaxes().stream().map(TaxField::toString).collect(Collectors.joining("%n       "))) + String.format(":Total net: %s%n", this.getTotalNet()) + String.format(":Total taxes: %s%n", SummaryHelper.formatAmount(this.getTotalTaxes())) + String.format(":Total amount: %s%n%n", this.getTotalAmount()) + String.format(":Line Items: %s%n", lineItemsSummary);
        return SummaryHelper.cleanSummary(summary);
    }

    public LocaleField getLocaleField() {
        return this.localeField;
    }

    public DocumentTypeField getDocumentType() {
        return this.documentType;
    }

    public DateField getInvoiceDateField() {
        return this.invoiceDateField;
    }

    public StringField getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public List<StringField> getReferenceNumbers() {
        return this.referenceNumbers;
    }

    public DateField getDueDateField() {
        return this.dueDateField;
    }

    public StringField getSupplierName() {
        return this.supplierName;
    }

    public List<PaymentDetailsField> getSupplierPaymentDetails() {
        return this.supplierPaymentDetails;
    }

    public List<CompanyRegistrationField> getSupplierCompanyRegistrations() {
        return this.supplierCompanyRegistrations;
    }

    public StringField getSupplierAddress() {
        return this.supplierAddress;
    }

    public StringField getCustomerName() {
        return this.customerName;
    }

    public List<CompanyRegistrationField> getCustomerCompanyRegistrations() {
        return this.customerCompanyRegistrations;
    }

    public StringField getCustomerAddress() {
        return this.customerAddress;
    }

    public List<TaxField> getTaxes() {
        return this.taxes;
    }

    public AmountField getTotalAmount() {
        return this.totalAmount;
    }

    public AmountField getTotalNet() {
        return this.totalNet;
    }

    public List<InvoiceLineItem> getLineItems() {
        return this.lineItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceV4DocumentPrediction)) {
            return false;
        }
        InvoiceV4DocumentPrediction other = (InvoiceV4DocumentPrediction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocaleField this$localeField = this.getLocaleField();
        LocaleField other$localeField = other.getLocaleField();
        if (this$localeField == null ? other$localeField != null : !this$localeField.equals(other$localeField)) {
            return false;
        }
        DocumentTypeField this$documentType = this.getDocumentType();
        DocumentTypeField other$documentType = other.getDocumentType();
        if (this$documentType == null ? other$documentType != null : !this$documentType.equals(other$documentType)) {
            return false;
        }
        DateField this$invoiceDateField = this.getInvoiceDateField();
        DateField other$invoiceDateField = other.getInvoiceDateField();
        if (this$invoiceDateField == null ? other$invoiceDateField != null : !this$invoiceDateField.equals(other$invoiceDateField)) {
            return false;
        }
        StringField this$invoiceNumber = this.getInvoiceNumber();
        StringField other$invoiceNumber = other.getInvoiceNumber();
        if (this$invoiceNumber == null ? other$invoiceNumber != null : !this$invoiceNumber.equals(other$invoiceNumber)) {
            return false;
        }
        List<StringField> this$referenceNumbers = this.getReferenceNumbers();
        List<StringField> other$referenceNumbers = other.getReferenceNumbers();
        if (this$referenceNumbers == null ? other$referenceNumbers != null : !((Object)this$referenceNumbers).equals(other$referenceNumbers)) {
            return false;
        }
        DateField this$dueDateField = this.getDueDateField();
        DateField other$dueDateField = other.getDueDateField();
        if (this$dueDateField == null ? other$dueDateField != null : !this$dueDateField.equals(other$dueDateField)) {
            return false;
        }
        StringField this$supplierName = this.getSupplierName();
        StringField other$supplierName = other.getSupplierName();
        if (this$supplierName == null ? other$supplierName != null : !this$supplierName.equals(other$supplierName)) {
            return false;
        }
        List<PaymentDetailsField> this$supplierPaymentDetails = this.getSupplierPaymentDetails();
        List<PaymentDetailsField> other$supplierPaymentDetails = other.getSupplierPaymentDetails();
        if (this$supplierPaymentDetails == null ? other$supplierPaymentDetails != null : !((Object)this$supplierPaymentDetails).equals(other$supplierPaymentDetails)) {
            return false;
        }
        List<CompanyRegistrationField> this$supplierCompanyRegistrations = this.getSupplierCompanyRegistrations();
        List<CompanyRegistrationField> other$supplierCompanyRegistrations = other.getSupplierCompanyRegistrations();
        if (this$supplierCompanyRegistrations == null ? other$supplierCompanyRegistrations != null : !((Object)this$supplierCompanyRegistrations).equals(other$supplierCompanyRegistrations)) {
            return false;
        }
        StringField this$supplierAddress = this.getSupplierAddress();
        StringField other$supplierAddress = other.getSupplierAddress();
        if (this$supplierAddress == null ? other$supplierAddress != null : !this$supplierAddress.equals(other$supplierAddress)) {
            return false;
        }
        StringField this$customerName = this.getCustomerName();
        StringField other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        List<CompanyRegistrationField> this$customerCompanyRegistrations = this.getCustomerCompanyRegistrations();
        List<CompanyRegistrationField> other$customerCompanyRegistrations = other.getCustomerCompanyRegistrations();
        if (this$customerCompanyRegistrations == null ? other$customerCompanyRegistrations != null : !((Object)this$customerCompanyRegistrations).equals(other$customerCompanyRegistrations)) {
            return false;
        }
        StringField this$customerAddress = this.getCustomerAddress();
        StringField other$customerAddress = other.getCustomerAddress();
        if (this$customerAddress == null ? other$customerAddress != null : !this$customerAddress.equals(other$customerAddress)) {
            return false;
        }
        List<TaxField> this$taxes = this.getTaxes();
        List<TaxField> other$taxes = other.getTaxes();
        if (this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes)) {
            return false;
        }
        AmountField this$totalAmount = this.getTotalAmount();
        AmountField other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !this$totalAmount.equals(other$totalAmount)) {
            return false;
        }
        AmountField this$totalNet = this.getTotalNet();
        AmountField other$totalNet = other.getTotalNet();
        if (this$totalNet == null ? other$totalNet != null : !this$totalNet.equals(other$totalNet)) {
            return false;
        }
        List<InvoiceLineItem> this$lineItems = this.getLineItems();
        List<InvoiceLineItem> other$lineItems = other.getLineItems();
        return !(this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvoiceV4DocumentPrediction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocaleField $localeField = this.getLocaleField();
        result = result * 59 + ($localeField == null ? 43 : $localeField.hashCode());
        DocumentTypeField $documentType = this.getDocumentType();
        result = result * 59 + ($documentType == null ? 43 : $documentType.hashCode());
        DateField $invoiceDateField = this.getInvoiceDateField();
        result = result * 59 + ($invoiceDateField == null ? 43 : $invoiceDateField.hashCode());
        StringField $invoiceNumber = this.getInvoiceNumber();
        result = result * 59 + ($invoiceNumber == null ? 43 : $invoiceNumber.hashCode());
        List<StringField> $referenceNumbers = this.getReferenceNumbers();
        result = result * 59 + ($referenceNumbers == null ? 43 : ((Object)$referenceNumbers).hashCode());
        DateField $dueDateField = this.getDueDateField();
        result = result * 59 + ($dueDateField == null ? 43 : $dueDateField.hashCode());
        StringField $supplierName = this.getSupplierName();
        result = result * 59 + ($supplierName == null ? 43 : $supplierName.hashCode());
        List<PaymentDetailsField> $supplierPaymentDetails = this.getSupplierPaymentDetails();
        result = result * 59 + ($supplierPaymentDetails == null ? 43 : ((Object)$supplierPaymentDetails).hashCode());
        List<CompanyRegistrationField> $supplierCompanyRegistrations = this.getSupplierCompanyRegistrations();
        result = result * 59 + ($supplierCompanyRegistrations == null ? 43 : ((Object)$supplierCompanyRegistrations).hashCode());
        StringField $supplierAddress = this.getSupplierAddress();
        result = result * 59 + ($supplierAddress == null ? 43 : $supplierAddress.hashCode());
        StringField $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        List<CompanyRegistrationField> $customerCompanyRegistrations = this.getCustomerCompanyRegistrations();
        result = result * 59 + ($customerCompanyRegistrations == null ? 43 : ((Object)$customerCompanyRegistrations).hashCode());
        StringField $customerAddress = this.getCustomerAddress();
        result = result * 59 + ($customerAddress == null ? 43 : $customerAddress.hashCode());
        List<TaxField> $taxes = this.getTaxes();
        result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
        AmountField $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : $totalAmount.hashCode());
        AmountField $totalNet = this.getTotalNet();
        result = result * 59 + ($totalNet == null ? 43 : $totalNet.hashCode());
        List<InvoiceLineItem> $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        return result;
    }
}

