/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.passport;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mindee.parsing.SummaryHelper;
import com.mindee.parsing.common.field.DateField;
import com.mindee.parsing.common.field.StringField;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PassportV1DocumentPrediction {
    @JsonProperty(value="country")
    private StringField country;
    @JsonProperty(value="id_number")
    private StringField idNumber;
    @JsonProperty(value="birth_date")
    private DateField birthDate;
    @JsonProperty(value="birth_place")
    private StringField birthPlace;
    @JsonProperty(value="expiry_date")
    private DateField expiryDate;
    @JsonProperty(value="gender")
    private StringField gender;
    @JsonProperty(value="given_names")
    private List<StringField> givenNames;
    @JsonProperty(value="surname")
    private StringField surname;
    @JsonProperty(value="issuance_date")
    private DateField issuanceDate;
    @JsonProperty(value="mrz1")
    private StringField mrz1;
    @JsonProperty(value="mrz2")
    private StringField mrz2;

    public String getMrz() {
        return this.mrz1.getValue() + this.mrz2.getValue();
    }

    public String getFullName() {
        return this.givenNames.stream().map(StringField::toString).collect(Collectors.joining(" ")) + " " + this.surname;
    }

    public String toString() {
        String summary = String.format(":Full name: %s%n", this.getFullName()) + String.format(":Given names: %s%n", this.getGivenNames().stream().map(StringField::toString).collect(Collectors.joining(" "))) + String.format(":Surname: %s%n", this.getSurname()) + String.format(":Country: %s%n", this.getCountry()) + String.format(":ID Number: %s%n", this.getIdNumber()) + String.format(":Issuance date: %s%n", this.getIssuanceDate()) + String.format(":Birth date: %s%n", this.getBirthDate()) + String.format(":Expiry date: %s%n", this.getExpiryDate()) + String.format(":MRZ 1: %s%n", this.getMrz1()) + String.format(":MRZ 2: %s%n", this.getMrz2()) + String.format(":MRZ: %s%n", this.getMrz());
        return SummaryHelper.cleanSummary(summary);
    }

    public StringField getCountry() {
        return this.country;
    }

    public StringField getIdNumber() {
        return this.idNumber;
    }

    public DateField getBirthDate() {
        return this.birthDate;
    }

    public StringField getBirthPlace() {
        return this.birthPlace;
    }

    public DateField getExpiryDate() {
        return this.expiryDate;
    }

    public StringField getGender() {
        return this.gender;
    }

    public List<StringField> getGivenNames() {
        return this.givenNames;
    }

    public StringField getSurname() {
        return this.surname;
    }

    public DateField getIssuanceDate() {
        return this.issuanceDate;
    }

    public StringField getMrz1() {
        return this.mrz1;
    }

    public StringField getMrz2() {
        return this.mrz2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassportV1DocumentPrediction)) {
            return false;
        }
        PassportV1DocumentPrediction other = (PassportV1DocumentPrediction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringField this$country = this.getCountry();
        StringField other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        StringField this$idNumber = this.getIdNumber();
        StringField other$idNumber = other.getIdNumber();
        if (this$idNumber == null ? other$idNumber != null : !this$idNumber.equals(other$idNumber)) {
            return false;
        }
        DateField this$birthDate = this.getBirthDate();
        DateField other$birthDate = other.getBirthDate();
        if (this$birthDate == null ? other$birthDate != null : !this$birthDate.equals(other$birthDate)) {
            return false;
        }
        StringField this$birthPlace = this.getBirthPlace();
        StringField other$birthPlace = other.getBirthPlace();
        if (this$birthPlace == null ? other$birthPlace != null : !this$birthPlace.equals(other$birthPlace)) {
            return false;
        }
        DateField this$expiryDate = this.getExpiryDate();
        DateField other$expiryDate = other.getExpiryDate();
        if (this$expiryDate == null ? other$expiryDate != null : !this$expiryDate.equals(other$expiryDate)) {
            return false;
        }
        StringField this$gender = this.getGender();
        StringField other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
            return false;
        }
        List<StringField> this$givenNames = this.getGivenNames();
        List<StringField> other$givenNames = other.getGivenNames();
        if (this$givenNames == null ? other$givenNames != null : !((Object)this$givenNames).equals(other$givenNames)) {
            return false;
        }
        StringField this$surname = this.getSurname();
        StringField other$surname = other.getSurname();
        if (this$surname == null ? other$surname != null : !this$surname.equals(other$surname)) {
            return false;
        }
        DateField this$issuanceDate = this.getIssuanceDate();
        DateField other$issuanceDate = other.getIssuanceDate();
        if (this$issuanceDate == null ? other$issuanceDate != null : !this$issuanceDate.equals(other$issuanceDate)) {
            return false;
        }
        StringField this$mrz1 = this.getMrz1();
        StringField other$mrz1 = other.getMrz1();
        if (this$mrz1 == null ? other$mrz1 != null : !this$mrz1.equals(other$mrz1)) {
            return false;
        }
        StringField this$mrz2 = this.getMrz2();
        StringField other$mrz2 = other.getMrz2();
        return !(this$mrz2 == null ? other$mrz2 != null : !this$mrz2.equals(other$mrz2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PassportV1DocumentPrediction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringField $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        StringField $idNumber = this.getIdNumber();
        result = result * 59 + ($idNumber == null ? 43 : $idNumber.hashCode());
        DateField $birthDate = this.getBirthDate();
        result = result * 59 + ($birthDate == null ? 43 : $birthDate.hashCode());
        StringField $birthPlace = this.getBirthPlace();
        result = result * 59 + ($birthPlace == null ? 43 : $birthPlace.hashCode());
        DateField $expiryDate = this.getExpiryDate();
        result = result * 59 + ($expiryDate == null ? 43 : $expiryDate.hashCode());
        StringField $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
        List<StringField> $givenNames = this.getGivenNames();
        result = result * 59 + ($givenNames == null ? 43 : ((Object)$givenNames).hashCode());
        StringField $surname = this.getSurname();
        result = result * 59 + ($surname == null ? 43 : $surname.hashCode());
        DateField $issuanceDate = this.getIssuanceDate();
        result = result * 59 + ($issuanceDate == null ? 43 : $issuanceDate.hashCode());
        StringField $mrz1 = this.getMrz1();
        result = result * 59 + ($mrz1 == null ? 43 : $mrz1.hashCode());
        StringField $mrz2 = this.getMrz2();
        result = result * 59 + ($mrz2 == null ? 43 : $mrz2.hashCode());
        return result;
    }
}

