/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.proofofaddress;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mindee.parsing.SummaryHelper;
import com.mindee.parsing.common.field.CompanyRegistrationField;
import com.mindee.parsing.common.field.DateField;
import com.mindee.parsing.common.field.LocaleField;
import com.mindee.parsing.common.field.StringField;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProofOfAddressV1DocumentPrediction {
    @JsonProperty(value="locale")
    private LocaleField locale;
    @JsonProperty(value="issuer_name")
    private StringField issuerName;
    @JsonProperty(value="issuer_company_registration")
    private List<CompanyRegistrationField> issuerCompanyRegistration = new ArrayList<CompanyRegistrationField>();
    @JsonProperty(value="issuer_address")
    private StringField issuerAddress;
    @JsonProperty(value="recipient_name")
    private StringField recipientName;
    @JsonProperty(value="recipient_company_registration")
    private List<CompanyRegistrationField> recipientCompanyRegistration = new ArrayList<CompanyRegistrationField>();
    @JsonProperty(value="recipient_address")
    private StringField recipientAddress;
    @JsonProperty(value="dates")
    private List<DateField> dates = new ArrayList<DateField>();
    @JsonProperty(value="date")
    private DateField date;

    public String toString() {
        String summary = String.format(":Locale: %s%n", this.getLocale()) + String.format(":Issuer Name: %s%n", this.getIssuerName()) + String.format(":Issuer Company Registrations: %s%n", SummaryHelper.arrayToString(this.getIssuerCompanyRegistration(), "%n                              ")) + String.format(":Issuer Address: %s%n", this.getIssuerAddress()) + String.format(":Recipient Name: %s%n", this.getRecipientName()) + String.format(":Recipient Company Registrations: %s%n", SummaryHelper.arrayToString(this.getRecipientCompanyRegistration(), "%n                                 ")) + String.format(":Recipient Address: %s%n", this.getRecipientAddress()) + String.format(":Dates: %s%n", SummaryHelper.arrayToString(this.getDates(), "%n        ")) + String.format(":Date of Issue: %s%n", this.getDate());
        return SummaryHelper.cleanSummary(summary);
    }

    public LocaleField getLocale() {
        return this.locale;
    }

    public StringField getIssuerName() {
        return this.issuerName;
    }

    public List<CompanyRegistrationField> getIssuerCompanyRegistration() {
        return this.issuerCompanyRegistration;
    }

    public StringField getIssuerAddress() {
        return this.issuerAddress;
    }

    public StringField getRecipientName() {
        return this.recipientName;
    }

    public List<CompanyRegistrationField> getRecipientCompanyRegistration() {
        return this.recipientCompanyRegistration;
    }

    public StringField getRecipientAddress() {
        return this.recipientAddress;
    }

    public List<DateField> getDates() {
        return this.dates;
    }

    public DateField getDate() {
        return this.date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProofOfAddressV1DocumentPrediction)) {
            return false;
        }
        ProofOfAddressV1DocumentPrediction other = (ProofOfAddressV1DocumentPrediction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocaleField this$locale = this.getLocale();
        LocaleField other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        StringField this$issuerName = this.getIssuerName();
        StringField other$issuerName = other.getIssuerName();
        if (this$issuerName == null ? other$issuerName != null : !this$issuerName.equals(other$issuerName)) {
            return false;
        }
        List<CompanyRegistrationField> this$issuerCompanyRegistration = this.getIssuerCompanyRegistration();
        List<CompanyRegistrationField> other$issuerCompanyRegistration = other.getIssuerCompanyRegistration();
        if (this$issuerCompanyRegistration == null ? other$issuerCompanyRegistration != null : !((Object)this$issuerCompanyRegistration).equals(other$issuerCompanyRegistration)) {
            return false;
        }
        StringField this$issuerAddress = this.getIssuerAddress();
        StringField other$issuerAddress = other.getIssuerAddress();
        if (this$issuerAddress == null ? other$issuerAddress != null : !this$issuerAddress.equals(other$issuerAddress)) {
            return false;
        }
        StringField this$recipientName = this.getRecipientName();
        StringField other$recipientName = other.getRecipientName();
        if (this$recipientName == null ? other$recipientName != null : !this$recipientName.equals(other$recipientName)) {
            return false;
        }
        List<CompanyRegistrationField> this$recipientCompanyRegistration = this.getRecipientCompanyRegistration();
        List<CompanyRegistrationField> other$recipientCompanyRegistration = other.getRecipientCompanyRegistration();
        if (this$recipientCompanyRegistration == null ? other$recipientCompanyRegistration != null : !((Object)this$recipientCompanyRegistration).equals(other$recipientCompanyRegistration)) {
            return false;
        }
        StringField this$recipientAddress = this.getRecipientAddress();
        StringField other$recipientAddress = other.getRecipientAddress();
        if (this$recipientAddress == null ? other$recipientAddress != null : !this$recipientAddress.equals(other$recipientAddress)) {
            return false;
        }
        List<DateField> this$dates = this.getDates();
        List<DateField> other$dates = other.getDates();
        if (this$dates == null ? other$dates != null : !((Object)this$dates).equals(other$dates)) {
            return false;
        }
        DateField this$date = this.getDate();
        DateField other$date = other.getDate();
        return !(this$date == null ? other$date != null : !this$date.equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProofOfAddressV1DocumentPrediction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocaleField $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        StringField $issuerName = this.getIssuerName();
        result = result * 59 + ($issuerName == null ? 43 : $issuerName.hashCode());
        List<CompanyRegistrationField> $issuerCompanyRegistration = this.getIssuerCompanyRegistration();
        result = result * 59 + ($issuerCompanyRegistration == null ? 43 : ((Object)$issuerCompanyRegistration).hashCode());
        StringField $issuerAddress = this.getIssuerAddress();
        result = result * 59 + ($issuerAddress == null ? 43 : $issuerAddress.hashCode());
        StringField $recipientName = this.getRecipientName();
        result = result * 59 + ($recipientName == null ? 43 : $recipientName.hashCode());
        List<CompanyRegistrationField> $recipientCompanyRegistration = this.getRecipientCompanyRegistration();
        result = result * 59 + ($recipientCompanyRegistration == null ? 43 : ((Object)$recipientCompanyRegistration).hashCode());
        StringField $recipientAddress = this.getRecipientAddress();
        result = result * 59 + ($recipientAddress == null ? 43 : $recipientAddress.hashCode());
        List<DateField> $dates = this.getDates();
        result = result * 59 + ($dates == null ? 43 : ((Object)$dates).hashCode());
        DateField $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        return result;
    }
}

