/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.receipt;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mindee.parsing.SummaryHelper;
import com.mindee.parsing.common.field.AmountField;
import com.mindee.parsing.common.field.DateField;
import com.mindee.parsing.common.field.DocumentTypeField;
import com.mindee.parsing.common.field.LocaleField;
import com.mindee.parsing.common.field.StringField;
import com.mindee.parsing.common.field.TaxField;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReceiptV4DocumentPrediction {
    @JsonProperty(value="locale")
    private LocaleField localeField;
    @JsonProperty(value="date")
    private DateField date;
    @JsonProperty(value="time")
    private StringField time;
    @JsonProperty(value="category")
    private StringField category;
    @JsonProperty(value="subcategory")
    private StringField subCategory;
    @JsonProperty(value="document_type")
    private DocumentTypeField documentType;
    @JsonProperty(value="supplier")
    private StringField supplierName;
    @JsonProperty(value="taxes")
    private List<TaxField> taxes = new ArrayList<TaxField>();
    @JsonProperty(value="total_amount")
    private AmountField totalAmount;
    @JsonProperty(value="total_net")
    private AmountField totalNet;
    @JsonProperty(value="total_tax")
    private AmountField totalTax;
    @JsonProperty(value="tip")
    private AmountField tip;

    public String toString() {
        String summary = String.format(":Locale: %s%n", this.getLocaleField()) + String.format(":Date: %s%n", this.getDate()) + String.format(":Category: %s%n", this.getCategory()) + String.format(":Subcategory: %s%n", this.getSubCategory()) + String.format(":Document type: %s%n", this.getDocumentType()) + String.format(":Time: %s%n", this.getTime()) + String.format(":Supplier name: %s%n", this.getSupplierName()) + String.format(":Taxes: %s%n", this.getTaxes().stream().map(TaxField::toString).collect(Collectors.joining("%n       "))) + String.format(":Total net: %s%n", this.getTotalNet()) + String.format(":Total taxes: %s%n", this.getTotalTax()) + String.format(":Tip: %s%n", this.getTip()) + String.format(":Total amount: %s%n", this.getTotalAmount());
        return SummaryHelper.cleanSummary(summary);
    }

    public LocaleField getLocaleField() {
        return this.localeField;
    }

    public DateField getDate() {
        return this.date;
    }

    public StringField getTime() {
        return this.time;
    }

    public StringField getCategory() {
        return this.category;
    }

    public StringField getSubCategory() {
        return this.subCategory;
    }

    public DocumentTypeField getDocumentType() {
        return this.documentType;
    }

    public StringField getSupplierName() {
        return this.supplierName;
    }

    public List<TaxField> getTaxes() {
        return this.taxes;
    }

    public AmountField getTotalAmount() {
        return this.totalAmount;
    }

    public AmountField getTotalNet() {
        return this.totalNet;
    }

    public AmountField getTotalTax() {
        return this.totalTax;
    }

    public AmountField getTip() {
        return this.tip;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceiptV4DocumentPrediction)) {
            return false;
        }
        ReceiptV4DocumentPrediction other = (ReceiptV4DocumentPrediction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocaleField this$localeField = this.getLocaleField();
        LocaleField other$localeField = other.getLocaleField();
        if (this$localeField == null ? other$localeField != null : !this$localeField.equals(other$localeField)) {
            return false;
        }
        DateField this$date = this.getDate();
        DateField other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        StringField this$time = this.getTime();
        StringField other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        StringField this$category = this.getCategory();
        StringField other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        StringField this$subCategory = this.getSubCategory();
        StringField other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        DocumentTypeField this$documentType = this.getDocumentType();
        DocumentTypeField other$documentType = other.getDocumentType();
        if (this$documentType == null ? other$documentType != null : !this$documentType.equals(other$documentType)) {
            return false;
        }
        StringField this$supplierName = this.getSupplierName();
        StringField other$supplierName = other.getSupplierName();
        if (this$supplierName == null ? other$supplierName != null : !this$supplierName.equals(other$supplierName)) {
            return false;
        }
        List<TaxField> this$taxes = this.getTaxes();
        List<TaxField> other$taxes = other.getTaxes();
        if (this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes)) {
            return false;
        }
        AmountField this$totalAmount = this.getTotalAmount();
        AmountField other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !this$totalAmount.equals(other$totalAmount)) {
            return false;
        }
        AmountField this$totalNet = this.getTotalNet();
        AmountField other$totalNet = other.getTotalNet();
        if (this$totalNet == null ? other$totalNet != null : !this$totalNet.equals(other$totalNet)) {
            return false;
        }
        AmountField this$totalTax = this.getTotalTax();
        AmountField other$totalTax = other.getTotalTax();
        if (this$totalTax == null ? other$totalTax != null : !this$totalTax.equals(other$totalTax)) {
            return false;
        }
        AmountField this$tip = this.getTip();
        AmountField other$tip = other.getTip();
        return !(this$tip == null ? other$tip != null : !this$tip.equals(other$tip));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReceiptV4DocumentPrediction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocaleField $localeField = this.getLocaleField();
        result = result * 59 + ($localeField == null ? 43 : $localeField.hashCode());
        DateField $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        StringField $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        StringField $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        StringField $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        DocumentTypeField $documentType = this.getDocumentType();
        result = result * 59 + ($documentType == null ? 43 : $documentType.hashCode());
        StringField $supplierName = this.getSupplierName();
        result = result * 59 + ($supplierName == null ? 43 : $supplierName.hashCode());
        List<TaxField> $taxes = this.getTaxes();
        result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
        AmountField $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : $totalAmount.hashCode());
        AmountField $totalNet = this.getTotalNet();
        result = result * 59 + ($totalNet == null ? 43 : $totalNet.hashCode());
        AmountField $totalTax = this.getTotalTax();
        result = result * 59 + ($totalTax == null ? 43 : $totalTax.hashCode());
        AmountField $tip = this.getTip();
        result = result * 59 + ($tip == null ? 43 : $tip.hashCode());
        return result;
    }
}

