/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.us.bankcheck;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mindee.parsing.SummaryHelper;
import com.mindee.parsing.common.field.AmountField;
import com.mindee.parsing.common.field.DateField;
import com.mindee.parsing.common.field.PositionField;
import com.mindee.parsing.common.field.StringField;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BankCheckV1DocumentPrediction {
    @JsonProperty(value="account_number")
    private StringField accountNumber;
    @JsonProperty(value="amount")
    private AmountField amount;
    @JsonProperty(value="check_number")
    private StringField checkNumber;
    @JsonProperty(value="check_position")
    private PositionField checkPosition;
    @JsonProperty(value="date")
    private DateField date;
    @JsonProperty(value="payees")
    private List<StringField> payees = new ArrayList<StringField>();
    @JsonProperty(value="routing_number")
    private StringField routingNumber;
    @JsonProperty(value="signatures_positions")
    private List<PositionField> signaturesPositions = new ArrayList<PositionField>();

    public String toString() {
        String summary = String.format(":Routing number: %s%n", this.getRoutingNumber()) + String.format(":Account number: %s%n", this.getAccountNumber()) + String.format(":Check number: %s%n", this.getCheckNumber()) + String.format(":Date: %s%n", this.getDate()) + String.format(":Amount: %s%n", this.getAmount()) + String.format(":Payees: %s%n", this.getPayees().stream().map(StringField::toString).collect(Collectors.joining(", ")));
        return SummaryHelper.cleanSummary(summary);
    }

    public StringField getAccountNumber() {
        return this.accountNumber;
    }

    public AmountField getAmount() {
        return this.amount;
    }

    public StringField getCheckNumber() {
        return this.checkNumber;
    }

    public PositionField getCheckPosition() {
        return this.checkPosition;
    }

    public DateField getDate() {
        return this.date;
    }

    public List<StringField> getPayees() {
        return this.payees;
    }

    public StringField getRoutingNumber() {
        return this.routingNumber;
    }

    public List<PositionField> getSignaturesPositions() {
        return this.signaturesPositions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankCheckV1DocumentPrediction)) {
            return false;
        }
        BankCheckV1DocumentPrediction other = (BankCheckV1DocumentPrediction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringField this$accountNumber = this.getAccountNumber();
        StringField other$accountNumber = other.getAccountNumber();
        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
            return false;
        }
        AmountField this$amount = this.getAmount();
        AmountField other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        StringField this$checkNumber = this.getCheckNumber();
        StringField other$checkNumber = other.getCheckNumber();
        if (this$checkNumber == null ? other$checkNumber != null : !this$checkNumber.equals(other$checkNumber)) {
            return false;
        }
        PositionField this$checkPosition = this.getCheckPosition();
        PositionField other$checkPosition = other.getCheckPosition();
        if (this$checkPosition == null ? other$checkPosition != null : !this$checkPosition.equals(other$checkPosition)) {
            return false;
        }
        DateField this$date = this.getDate();
        DateField other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        List<StringField> this$payees = this.getPayees();
        List<StringField> other$payees = other.getPayees();
        if (this$payees == null ? other$payees != null : !((Object)this$payees).equals(other$payees)) {
            return false;
        }
        StringField this$routingNumber = this.getRoutingNumber();
        StringField other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) {
            return false;
        }
        List<PositionField> this$signaturesPositions = this.getSignaturesPositions();
        List<PositionField> other$signaturesPositions = other.getSignaturesPositions();
        return !(this$signaturesPositions == null ? other$signaturesPositions != null : !((Object)this$signaturesPositions).equals(other$signaturesPositions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankCheckV1DocumentPrediction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringField $accountNumber = this.getAccountNumber();
        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
        AmountField $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        StringField $checkNumber = this.getCheckNumber();
        result = result * 59 + ($checkNumber == null ? 43 : $checkNumber.hashCode());
        PositionField $checkPosition = this.getCheckPosition();
        result = result * 59 + ($checkPosition == null ? 43 : $checkPosition.hashCode());
        DateField $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        List<StringField> $payees = this.getPayees();
        result = result * 59 + ($payees == null ? 43 : ((Object)$payees).hashCode());
        StringField $routingNumber = this.getRoutingNumber();
        result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        List<PositionField> $signaturesPositions = this.getSignaturesPositions();
        result = result * 59 + ($signaturesPositions == null ? 43 : ((Object)$signaturesPositions).hashCode());
        return result;
    }
}

