/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;

public final class PDFUtils {
    private PDFUtils() {
    }

    private static int countPDDocumentPages(PDDocument document) throws IOException {
        int pageCount = document.getNumberOfPages();
        document.close();
        return pageCount;
    }

    public static int countPdfPages(File file) throws IOException {
        PDDocument document = PDDocument.load((File)file);
        return PDFUtils.countPDDocumentPages(document);
    }

    public static int countPdfPages(byte[] bytes) throws IOException {
        PDDocument document = PDDocument.load((byte[])bytes);
        return PDFUtils.countPDDocumentPages(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countPdfPages(InputStream inputStream) throws IOException {
        try {
            PDDocument document = PDDocument.load((InputStream)inputStream);
            int pageCount = PDFUtils.countPDDocumentPages(document);
            document.close();
            int n = pageCount;
            return n;
        }
        finally {
            inputStream.close();
        }
    }

    private static byte[] createPdfFromExistingPdf(PDDocument document, List<Integer> pageNumbers) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PDDocument newDocument = new PDDocument();
        int pageCount = document.getNumberOfPages();
        pageNumbers.stream().filter(i -> i < pageCount).forEach(i -> newDocument.addPage(document.getPage(i.intValue())));
        newDocument.save((OutputStream)outputStream);
        newDocument.close();
        document.close();
        byte[] output = outputStream.toByteArray();
        outputStream.close();
        return output;
    }

    public static byte[] mergePdfPages(File file, List<Integer> pageNumbers) throws IOException {
        PDDocument document = PDDocument.load((File)file);
        return PDFUtils.createPdfFromExistingPdf(document, pageNumbers);
    }

    public static byte[] mergePdfPages(byte[] fileBytes, List<Integer> pageNumbers) throws IOException {
        PDDocument document = PDDocument.load((byte[])fileBytes);
        return PDFUtils.createPdfFromExistingPdf(document, pageNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] mergePdfPages(InputStream inputStream, List<Integer> pageNumbers) throws IOException {
        try {
            PDDocument document = PDDocument.load((InputStream)inputStream);
            byte[] bytes = PDFUtils.createPdfFromExistingPdf(document, pageNumbers);
            document.close();
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public static boolean isPdfEmpty(File file) throws IOException {
        return PDFUtils.checkIfPdfIsEmpty(PDDocument.load((File)file));
    }

    public static boolean isPdfEmpty(InputStream inputStream) throws IOException {
        return PDFUtils.checkIfPdfIsEmpty(PDDocument.load((InputStream)inputStream));
    }

    public static boolean isPdfEmpty(byte[] fileBytes) throws IOException {
        return PDFUtils.checkIfPdfIsEmpty(PDDocument.load((byte[])fileBytes));
    }

    private static boolean checkIfPdfIsEmpty(PDDocument document) throws IOException {
        boolean isEmpty = true;
        for (PDPage page : document.getPages()) {
            PDResources resources = page.getResources();
            if (resources == null) continue;
            Iterable xObjects = resources.getXObjectNames();
            Iterable fonts = resources.getFontNames();
            if (xObjects.spliterator().getExactSizeIfKnown() == 0L && fonts.spliterator().getExactSizeIfKnown() == 0L) continue;
            isEmpty = false;
            break;
        }
        document.close();
        return isEmpty;
    }

    public static boolean checkPdfOpen(InputStream inputStream) {
        boolean opens = false;
        try {
            PDDocument.load((InputStream)inputStream).close();
            opens = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return opens;
    }

    public static boolean checkPdfOpen(File file) {
        boolean opens = false;
        try {
            PDDocument.load((File)file).close();
            opens = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return opens;
    }

    public static boolean checkPdfOpen(byte[] fileBytes) {
        boolean opens = false;
        try {
            PDDocument.load((byte[])fileBytes).close();
            opens = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return opens;
    }
}

