/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.paracamera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcelable;
import com.mindorks.paracamera.Utils;
import java.io.File;

public class Camera {
    public static final int REQUEST_TAKE_PHOTO = 1;
    public static final String IMAGE_JPG = "jpg";
    public static final String IMAGE_JPEG = "jpeg";
    public static final String IMAGE_PNG = "png";
    private static final String IMAGE_FORMAT_JPG = ".jpg";
    private static final String IMAGE_FORMAT_JPEG = ".jpeg";
    private static final String IMAGE_FORMAT_PNG = ".png";
    private static final int IMAGE_HEIGHT = 1000;
    private static final int IMAGE_COMPRESSION = 75;
    private static final String IMAGE_DEFAULT_DIR = "capture";
    private static final String IMAGE_DEFAULT_NAME = "img_";
    private Context context;
    private Activity activity;
    private String cameraBitmapPath = null;
    private Bitmap cameraBitmap = null;
    private String dirName;
    private String imageName;
    private String imageType;
    private int imageHeight;
    private int compression;

    public Camera(Activity activity) {
        this.activity = activity;
        this.context = activity.getApplicationContext();
        this.dirName = IMAGE_DEFAULT_DIR;
        this.imageName = IMAGE_DEFAULT_NAME + System.currentTimeMillis();
        this.imageHeight = 1000;
        this.compression = 75;
        this.imageType = IMAGE_FORMAT_JPG;
    }

    public CameraBuilder builder() {
        return new CameraBuilder();
    }

    public void takePicture() throws NullPointerException {
        File photoFile;
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.activity.getPackageManager()) != null) {
            photoFile = Utils.createImageFile(this.context, this.dirName, this.imageName, this.imageType);
            if (photoFile == null) {
                throw new NullPointerException("Bitmap received from camera is null");
            }
        } else {
            throw new NullPointerException("Unable to open camera");
        }
        this.cameraBitmapPath = photoFile.getAbsolutePath();
        takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
        this.activity.startActivityForResult(takePictureIntent, 1);
    }

    public String getCameraBitmapPath() {
        Bitmap bitmap = this.getCameraBitmap();
        bitmap.recycle();
        return this.cameraBitmapPath;
    }

    public Bitmap getCameraBitmap() {
        try {
            if (this.cameraBitmap != null) {
                this.cameraBitmap.recycle();
            }
            this.cameraBitmap = Utils.decodeFile(new File(this.cameraBitmapPath), this.imageHeight);
            if (this.cameraBitmap != null) {
                Utils.saveBitmap(this.cameraBitmap, this.cameraBitmapPath, this.imageType, this.compression);
            }
            return this.cameraBitmap;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String resizeAndGetCameraBitmapPath(int imageHeight) {
        Bitmap bitmap = this.resizeAndGetCameraBitmap(imageHeight);
        bitmap.recycle();
        return this.cameraBitmapPath;
    }

    public Bitmap resizeAndGetCameraBitmap(int imageHeight) {
        try {
            if (this.cameraBitmap != null) {
                this.cameraBitmap.recycle();
            }
            this.cameraBitmap = Utils.decodeFile(new File(this.cameraBitmapPath), imageHeight);
            if (this.cameraBitmap != null) {
                Utils.saveBitmap(this.cameraBitmap, this.cameraBitmapPath, this.imageType, this.compression);
            }
            return this.cameraBitmap;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void deleteImage() {
        File image;
        if (this.cameraBitmapPath != null && (image = new File(this.cameraBitmapPath)).exists()) {
            image.delete();
        }
    }

    public class CameraBuilder {
        public CameraBuilder setDirectory(String dirName) {
            Camera.this.dirName = dirName;
            return this;
        }

        public CameraBuilder setName(String imageName) {
            Camera.this.imageName = imageName;
            return this;
        }

        public CameraBuilder setImageFormat(String imageFormat) {
            if (imageFormat == null) {
                Camera.this.imageType = Camera.IMAGE_FORMAT_JPG;
            }
            if (imageFormat.equals(Camera.IMAGE_PNG) || imageFormat.equals("PNG") || imageFormat.equals(Camera.IMAGE_FORMAT_PNG)) {
                Camera.this.imageType = Camera.IMAGE_FORMAT_PNG;
            } else if (imageFormat.equals(Camera.IMAGE_JPG) || imageFormat.equals("JPG") || imageFormat.equals(Camera.IMAGE_FORMAT_JPG)) {
                Camera.this.imageType = Camera.IMAGE_FORMAT_JPG;
            } else if (imageFormat.equals(Camera.IMAGE_JPEG) || imageFormat.equals("JPEG") || imageFormat.equals(Camera.IMAGE_FORMAT_JPEG)) {
                Camera.this.imageType = Camera.IMAGE_FORMAT_JPEG;
            } else {
                Camera.this.imageType = Camera.IMAGE_FORMAT_JPG;
            }
            return this;
        }

        public CameraBuilder setImageHeight(int imageHeight) {
            Camera.this.imageHeight = imageHeight;
            return this;
        }

        public CameraBuilder setCompression(int compression) {
            if (compression > 100) {
                compression = 100;
            } else if (compression < 0) {
                compression = 0;
            }
            Camera.this.compression = compression;
            return this;
        }
    }
}

