/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.paracamera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Utils {
    public static File createImageFile(Context context, String dirName, String fileName, String fileType) {
        try {
            File file = Utils.createDir(context, dirName);
            File image = new File(file.getAbsoluteFile() + File.separator + fileName + fileType);
            image.createNewFile();
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File createDir(Context context, String dirName) {
        File file = new File(context.getExternalFilesDir(null) + File.separator + dirName);
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    public static Bitmap decodeFile(File file, int requiredHeight) {
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)o);
            int scale = 1;
            while (o.outWidth / scale / 2 >= requiredHeight && o.outHeight / scale / 2 >= requiredHeight) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            return BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)o2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBitmap(Bitmap bitmap, String filePath, String imageType, int compression) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            if (imageType.equals("png") || imageType.equals("PNG") || imageType.equals(".png")) {
                bitmap.compress(Bitmap.CompressFormat.PNG, compression, (OutputStream)out);
            } else if (imageType.equals("jpg") || imageType.equals("JPG") || imageType.equals(".jpg")) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, compression, (OutputStream)out);
            } else if (imageType.equals("jpeg") || imageType.equals("JPEG") || imageType.equals(".jpeg")) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, compression, (OutputStream)out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

