/*
 * Decompiled with CFR 0.152.
 */
package com.mindprogeny.wiremock.extension.scenario;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import wiremock.com.google.common.collect.ImmutableMap;

public class StringValuePatternBuilder {
    private static final Map<String, Class<? extends StringValuePattern>> MATCHERS = new ImmutableMap.Builder().put((Object)"equalTo", EqualToPattern.class).put((Object)"equalToJson", EqualToJsonPattern.class).put((Object)"matchesJsonPath", MatchesJsonPathPattern.class).put((Object)"equalToXml", EqualToXmlPattern.class).put((Object)"matchesXPath", MatchesXPathPattern.class).put((Object)"contains", ContainsPattern.class).put((Object)"matches", RegexPattern.class).put((Object)"doesNotMatch", NegativeRegexPattern.class).put((Object)"anything", AnythingPattern.class).build();

    public static StringValuePattern build(Map<String, Object> matchParameters) {
        Class<? extends StringValuePattern> patternClass = null;
        Object matchPattern = null;
        for (String matchMethod : matchParameters.keySet()) {
            patternClass = MATCHERS.get(matchMethod);
            if (patternClass == null) continue;
            matchPattern = matchParameters.get(matchMethod);
            break;
        }
        if (patternClass == null) {
            return StringValuePattern.ABSENT;
        }
        if (patternClass.equals(EqualToJsonPattern.class)) {
            Boolean ignoreArrayOrder = (Boolean)matchParameters.get("ignoreArrayOrder");
            Boolean ignoreExtraElements = (Boolean)matchParameters.get("ignoreExtraElements");
            return new EqualToJsonPattern(matchPattern instanceof String ? (String)matchPattern : Json.write((Object)matchPattern), Boolean.valueOf(ignoreArrayOrder == null ? false : ignoreArrayOrder), Boolean.valueOf(ignoreExtraElements == null ? false : ignoreExtraElements));
        }
        if (patternClass.equals(MatchesXPathPattern.class)) {
            Map namespaces = (Map)matchParameters.get("xPathNamespaces");
            return new MatchesXPathPattern(matchPattern.toString(), namespaces == null ? Collections.emptyMap() : namespaces);
        }
        try {
            Constructor<? extends StringValuePattern> constructor = patternClass.getConstructor(String.class);
            return constructor.newInstance(matchPattern);
        }
        catch (Exception e) {
            return (StringValuePattern)Exceptions.throwUnchecked((Throwable)e, StringValuePattern.class);
        }
    }
}

