/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core;

import com.google.gson.Gson;
import com.mindscapehq.raygun4java.core.RaygunConnection;
import com.mindscapehq.raygun4java.core.RaygunMessageBuilder;
import com.mindscapehq.raygun4java.core.RaygunOnBeforeSend;
import com.mindscapehq.raygun4java.core.RaygunSettings;
import com.mindscapehq.raygun4java.core.messages.RaygunIdentifier;
import com.mindscapehq.raygun4java.core.messages.RaygunMessage;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaygunClient {
    private RaygunConnection raygunConnection;
    protected String _apiKey;
    protected RaygunIdentifier _user;
    protected String _context;
    protected String _version = null;
    private static RaygunOnBeforeSend _onBeforeSend;

    public void setRaygunConnection(RaygunConnection raygunConnection) {
        this.raygunConnection = raygunConnection;
    }

    public RaygunClient(String apiKey) {
        this._apiKey = apiKey;
        this.raygunConnection = new RaygunConnection(RaygunSettings.GetSettings());
    }

    protected Boolean ValidateApiKey() throws Exception {
        if (this._apiKey.isEmpty()) {
            throw new Exception("API key has not been provided, exception will not be logged");
        }
        return true;
    }

    protected String GetMachineName() {
        String machineName = "Unknown machine";
        try {
            InetAddress address = InetAddress.getLocalHost();
            machineName = address.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return machineName;
    }

    public void SetUser(RaygunIdentifier userIdentity) {
        this._user = userIdentity;
    }

    @Deprecated
    public void SetUser(String user) {
        RaygunIdentifier ident;
        this._user = ident = new RaygunIdentifier(user);
    }

    public void SetVersion(String version) {
        this._version = version;
    }

    public int Send(Throwable throwable) {
        return this.Post(this.BuildMessage(throwable));
    }

    public int Send(Throwable throwable, List<?> tags) {
        return this.Post(this.BuildMessage(throwable, tags));
    }

    public int Send(Throwable throwable, List<?> tags, Map<?, ?> userCustomData) {
        return this.Post(this.BuildMessage(throwable, tags, userCustomData));
    }

    private RaygunMessage BuildMessage(Throwable throwable) {
        try {
            RaygunMessage message = RaygunMessageBuilder.New().SetEnvironmentDetails().SetMachineName(this.GetMachineName()).SetExceptionDetails(throwable).SetClientDetails().SetVersion(this._version).SetUser(this._user).Build();
            return message;
        }
        catch (Throwable t) {
            Logger.getLogger("Raygun4Java").throwing("RaygunClient", "BuildMessage", t);
            return null;
        }
    }

    private RaygunMessage BuildMessage(Throwable throwable, List<?> tags) {
        try {
            return RaygunMessageBuilder.New().SetEnvironmentDetails().SetMachineName(this.GetMachineName()).SetExceptionDetails(throwable).SetClientDetails().SetVersion(this._version).SetTags(tags).SetUser(this._user).Build();
        }
        catch (Throwable t) {
            Logger.getLogger("Raygun4Java").throwing("RaygunClient", "BuildMessage-t", t);
            return null;
        }
    }

    private RaygunMessage BuildMessage(Throwable throwable, List<?> tags, Map<?, ?> userCustomData) {
        try {
            return RaygunMessageBuilder.New().SetEnvironmentDetails().SetMachineName(this.GetMachineName()).SetExceptionDetails(throwable).SetClientDetails().SetVersion(this._version).SetTags(tags).SetUserCustomData(userCustomData).SetUser(this._user).Build();
        }
        catch (Throwable t) {
            Logger.getLogger("Raygun4Java").throwing("RaygunClient", "BuildMessage-t-m", t);
            return null;
        }
    }

    public int Post(RaygunMessage raygunMessage) {
        try {
            if (this.ValidateApiKey().booleanValue()) {
                if (_onBeforeSend != null && (raygunMessage = _onBeforeSend.OnBeforeSend(raygunMessage)) == null) {
                    return -1;
                }
                String jsonPayload = new Gson().toJson((Object)raygunMessage);
                HttpURLConnection connection = this.raygunConnection.getConnection(this._apiKey);
                OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), "UTF8");
                writer.write(jsonPayload);
                writer.flush();
                writer.close();
                connection.disconnect();
                return connection.getResponseCode();
            }
        }
        catch (Throwable t) {
            Logger.getLogger("Raygun4Java").warning("Couldn't post exception: " + t.getMessage());
        }
        return -1;
    }

    public static void SetOnBeforeSend(RaygunOnBeforeSend onBeforeSend) {
        _onBeforeSend = onBeforeSend;
    }
}

