/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core;

import com.mindscapehq.raygun4java.core.IRaygunMessageBuilder;
import com.mindscapehq.raygun4java.core.messages.RaygunClientMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunEnvironmentMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunErrorMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunIdentifier;
import com.mindscapehq.raygun4java.core.messages.RaygunMessage;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaygunMessageBuilder
implements IRaygunMessageBuilder {
    protected RaygunMessage _raygunMessage = new RaygunMessage();

    @Override
    public RaygunMessage Build() {
        return this._raygunMessage;
    }

    public static RaygunMessageBuilder New() {
        return new RaygunMessageBuilder();
    }

    @Override
    public IRaygunMessageBuilder SetMachineName(String machineName) {
        this._raygunMessage.getDetails().setMachineName(machineName);
        return this;
    }

    @Override
    public IRaygunMessageBuilder SetExceptionDetails(Throwable throwable) {
        this._raygunMessage.getDetails().setError(new RaygunErrorMessage(throwable));
        return this;
    }

    @Override
    public IRaygunMessageBuilder SetClientDetails() {
        this._raygunMessage.getDetails().setClient(new RaygunClientMessage());
        return this;
    }

    @Override
    public IRaygunMessageBuilder SetEnvironmentDetails() {
        this._raygunMessage.getDetails().setEnvironment(new RaygunEnvironmentMessage());
        return this;
    }

    @Override
    public IRaygunMessageBuilder SetVersion(String version) {
        if (version != null) {
            this._raygunMessage.getDetails().setVersion(version);
        } else {
            this._raygunMessage.getDetails().setVersion(this.ReadVersion());
        }
        return this;
    }

    @Override
    public IRaygunMessageBuilder SetTags(List<?> tags) {
        this._raygunMessage.getDetails().setTags(tags);
        return this;
    }

    @Override
    public IRaygunMessageBuilder SetUserCustomData(Map<?, ?> userCustomData) {
        this._raygunMessage.getDetails().setUserCustomData(userCustomData);
        return this;
    }

    @Override
    public IRaygunMessageBuilder SetUser(RaygunIdentifier user) {
        this._raygunMessage.getDetails().setUser(user);
        return this;
    }

    @Override
    public IRaygunMessageBuilder SetGroupingKey(String groupingKey) {
        this._raygunMessage.getDetails().setGroupingKey(groupingKey);
        return this;
    }

    private String ReadVersion() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StackTraceElement main = stack[stack.length - 1];
        String mainClass = main.getClassName();
        try {
            Class<?> cl = this.getClass().getClassLoader().loadClass(mainClass);
            String className = cl.getSimpleName() + ".class";
            String classPath = cl.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return null;
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            if (attr.getValue("Specification-Version") != null) {
                return attr.getValue("Specification-Version");
            }
            if (attr.getValue("Implementation-Version") != null) {
                return attr.getValue("Implementation-Version");
            }
        }
        catch (Exception e) {
            Logger.getLogger("Raygun4Java").warning("Cannot read version from manifest: " + e.getMessage());
        }
        return "Not supplied";
    }
}

