/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core.messages;

import java.awt.GraphicsEnvironment;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.util.Locale;
import java.util.TimeZone;

public class RaygunEnvironmentMessage {
    private String cpu;
    private String architecture;
    private int processorCount;
    private String osVersion;
    private int windowBoundsWidth;
    private int windowBoundsHeight;
    private String currentOrientation;
    private String locale;
    private long totalPhysicalMemory;
    private long availablePhysicalMemory;
    private long totalVirtualMemory;
    private long availableVirtualMemory;
    private int diskSpaceFree;
    private double utcOffset;

    public RaygunEnvironmentMessage() {
        try {
            this.utcOffset = (double)TimeZone.getDefault().getRawOffset() / 3600000.0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.locale = Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.windowBoundsWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width;
            this.windowBoundsHeight = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.processorCount = Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
            this.totalVirtualMemory = memBean.getHeapMemoryUsage().getMax() + memBean.getNonHeapMemoryUsage().getMax();
            this.availableVirtualMemory = memBean.getHeapMemoryUsage().getUsed() + memBean.getNonHeapMemoryUsage().getUsed();
        }
        catch (Throwable memBean) {
            // empty catch block
        }
        try {
            OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
            this.architecture = osMXBean.getArch();
            this.osVersion = osMXBean.getName() + " - " + osMXBean.getVersion();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

