/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core.messages;

import com.mindscapehq.raygun4java.core.messages.RaygunErrorStackTraceLineMessage;

public class RaygunErrorMessage {
    private RaygunErrorMessage innerError;
    private String message;
    private String className;
    private RaygunErrorStackTraceLineMessage[] stackTrace;

    public RaygunErrorMessage(Throwable throwable) {
        this.message = throwable.getClass().getSimpleName();
        String throwableMessage = throwable.getMessage();
        if (throwableMessage != null) {
            this.message = this.message.concat(": ").concat(throwableMessage);
        }
        this.className = throwable.getClass().getCanonicalName();
        if (throwable.getCause() != null) {
            this.innerError = new RaygunErrorMessage((Exception)throwable.getCause());
        }
        StackTraceElement[] ste = throwable.getStackTrace();
        this.stackTrace = new RaygunErrorStackTraceLineMessage[ste.length];
        for (int i = 0; i < ste.length; ++i) {
            this.stackTrace[i] = new RaygunErrorStackTraceLineMessage(ste[i]);
        }
    }

    public RaygunErrorMessage getInnerError() {
        return this.innerError;
    }

    public void setInnerError(RaygunErrorMessage innerError) {
        this.innerError = innerError;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public RaygunErrorStackTraceLineMessage[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(RaygunErrorStackTraceLineMessage[] stackTrace) {
        this.stackTrace = stackTrace;
    }
}

