/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core;

import com.mindscapehq.raygun4java.core.IRaygunSendEventFactory;
import com.mindscapehq.raygun4java.core.IRaygunSentEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRaygunSendEventChainFactory<T extends IRaygunSentEvent> {
    private List<IRaygunSendEventFactory<T>> mainHandlersFactories;
    private IRaygunSendEventFactory<T> lastFilterFactory;
    private IRaygunSendEventFactory<T> firstFilterFactory;

    protected abstract T create(List<T> var1);

    public T create() {
        ArrayList<IRaygunSentEvent> handlers = new ArrayList<IRaygunSentEvent>(this.mainHandlersFactories.size() + 2);
        if (this.firstFilterFactory != null) {
            handlers.add((IRaygunSentEvent)this.firstFilterFactory.create());
        }
        for (IRaygunSendEventFactory<T> mainHandlerFactory : this.mainHandlersFactories) {
            handlers.add((IRaygunSentEvent)mainHandlerFactory.create());
        }
        if (this.lastFilterFactory != null) {
            handlers.add((IRaygunSentEvent)this.lastFilterFactory.create());
        }
        return (T)this.create(handlers);
    }

    public AbstractRaygunSendEventChainFactory() {
        this(new ArrayList<IRaygunSendEventFactory<T>>());
    }

    public AbstractRaygunSendEventChainFactory(List<IRaygunSendEventFactory<T>> handlers) {
        this.mainHandlersFactories = handlers;
    }

    public AbstractRaygunSendEventChainFactory<T> withFilterFactory(IRaygunSendEventFactory<T> handler) {
        this.mainHandlersFactories.add(handler);
        return this;
    }

    public AbstractRaygunSendEventChainFactory<T> beforeAll(IRaygunSendEventFactory<T> firstFilter) {
        this.firstFilterFactory = firstFilter;
        return this;
    }

    public AbstractRaygunSendEventChainFactory<T> afterAll(IRaygunSendEventFactory<T> lastFilter) {
        this.lastFilterFactory = lastFilter;
        return this;
    }

    public List<IRaygunSendEventFactory<T>> getHandlersFactory() {
        return this.mainHandlersFactories;
    }

    public void setHandlersFactory(List<IRaygunSendEventFactory<T>> handlersFactory) {
        this.mainHandlersFactories = handlersFactory;
    }

    public IRaygunSendEventFactory getLastFilterFactory() {
        return this.lastFilterFactory;
    }

    public void setLastFilterFactory(IRaygunSendEventFactory<T> lastFilterFactory) {
        this.lastFilterFactory = lastFilterFactory;
    }

    public IRaygunSendEventFactory getFirstFilterFactory() {
        return this.firstFilterFactory;
    }

    public void setFirstFilterFactory(IRaygunSendEventFactory<T> firstFilterFactory) {
        this.firstFilterFactory = firstFilterFactory;
    }
}

