/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core;

import com.google.gson.Gson;
import com.mindscapehq.raygun4java.core.IRaygunMessageBuilder;
import com.mindscapehq.raygun4java.core.IRaygunOnAfterSend;
import com.mindscapehq.raygun4java.core.IRaygunOnBeforeSend;
import com.mindscapehq.raygun4java.core.IRaygunOnFailedSend;
import com.mindscapehq.raygun4java.core.RaygunConnection;
import com.mindscapehq.raygun4java.core.RaygunMessageBuilder;
import com.mindscapehq.raygun4java.core.RaygunSettings;
import com.mindscapehq.raygun4java.core.messages.RaygunBreadcrumbMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunIdentifier;
import com.mindscapehq.raygun4java.core.messages.RaygunMessage;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class RaygunClient {
    protected static final String UNHANDLED_EXCEPTION = "UnhandledException";
    private RaygunConnection raygunConnection;
    protected String apiKey;
    protected RaygunIdentifier user;
    protected String context;
    protected String string = null;
    protected IRaygunOnBeforeSend onBeforeSend;
    protected IRaygunOnAfterSend onAfterSend;
    protected IRaygunOnFailedSend onFailedSend;
    protected List<RaygunBreadcrumbMessage> breadcrumbs;
    protected Set<String> clientTags;
    protected Map clientData;
    protected boolean shouldProcessBreadcrumbLocation = false;

    public void setRaygunConnection(RaygunConnection raygunConnection) {
        this.raygunConnection = raygunConnection;
    }

    public RaygunClient(String apiKey) {
        this.apiKey = apiKey;
        this.raygunConnection = new RaygunConnection(RaygunSettings.getSettings());
        this.breadcrumbs = new ArrayList<RaygunBreadcrumbMessage>();
        this.clientTags = new HashSet<String>();
        this.clientData = new WeakHashMap();
    }

    protected Boolean validateApiKey() throws Exception {
        if (this.apiKey == null || this.apiKey.length() == 0) {
            throw new Exception("API key has not been provided, exception will not be logged");
        }
        return true;
    }

    protected String getMachineName() {
        String machineName = "Unknown machine";
        try {
            InetAddress address = InetAddress.getLocalHost();
            machineName = address.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return machineName;
    }

    public void setUser(RaygunIdentifier userIdentity) {
        this.user = userIdentity;
    }

    public void setVersion(String version) {
        this.string = version;
    }

    public void setVersionFrom(Class getVersionFrom) {
        this.string = new RaygunMessageBuilder().setVersionFrom(getVersionFrom).build().getDetails().getVersion();
    }

    public int send(Throwable throwable) {
        return this.send(throwable, null, null);
    }

    public int send(Throwable throwable, Set<String> tags) {
        return this.send(throwable, tags, null);
    }

    public int send(Throwable throwable, Map data) {
        return this.send(throwable, null, data);
    }

    public int send(Throwable throwable, Set<String> tags, Map data) {
        return this.send(this.buildMessage(throwable, tags, data));
    }

    public int sendUnhandled(Throwable throwable) {
        return this.send(throwable, new HashSet<String>(), null);
    }

    public int sendUnhandled(Throwable throwable, Map data) {
        return this.send(throwable, new HashSet<String>(), data);
    }

    public int sendUnhandled(Throwable throwable, Set<String> tags) {
        return this.send(throwable, tags, null);
    }

    public int sendUnhandled(Throwable throwable, Set<String> tags, Map data) {
        HashSet<String> newTags = new HashSet<String>(tags);
        newTags.add(UNHANDLED_EXCEPTION);
        return this.send(this.buildMessage(throwable, newTags, data));
    }

    protected Set<String> getTagsForError(Set<String> errorTags) {
        HashSet<String> tags = new HashSet<String>(this.clientTags);
        if (errorTags != null) {
            tags.addAll(errorTags);
        }
        return tags;
    }

    protected Map getDataForError(Map errorData) {
        HashMap data = new HashMap(this.clientData);
        if (errorData != null) {
            data.putAll(errorData);
        }
        return data;
    }

    public RaygunMessage buildMessage(Throwable throwable, Set<String> errorTags, Map errorData) {
        try {
            return this.buildMessage(RaygunMessageBuilder.newMessageBuilder(), throwable, this.getTagsForError(errorTags), this.getDataForError(errorData)).build();
        }
        catch (Throwable t) {
            Logger.getLogger("Raygun4Java").throwing("RaygunClient", "buildMessage-t-m", t);
            return null;
        }
    }

    protected <T extends IRaygunMessageBuilder> IRaygunMessageBuilder buildMessage(T builder, Throwable throwable, Set<String> tags, Map data) {
        return builder.setEnvironmentDetails().setMachineName(this.getMachineName()).setExceptionDetails(throwable).setClientDetails().setVersion(this.string).setTags(tags).setUserCustomData(data).setUser(this.user).setBreadrumbs(this.breadcrumbs);
    }

    public int send(RaygunMessage raygunMessage) {
        block9: {
            try {
                if (!this.validateApiKey().booleanValue()) break block9;
                if (this.onBeforeSend != null && (raygunMessage = this.onBeforeSend.onBeforeSend(this, raygunMessage)) == null) {
                    return -1;
                }
                String jsonPayload = this.toJson(raygunMessage);
                int responseCode = -1;
                try {
                    responseCode = this.send(jsonPayload);
                }
                catch (Exception e) {
                    if (this.onFailedSend != null) {
                        this.onFailedSend.onFailedSend(this, jsonPayload);
                    }
                    return responseCode;
                }
                try {
                    if (this.onAfterSend != null) {
                        this.onAfterSend.onAfterSend(this, raygunMessage);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("Raygun4Java").warning("exception processing onAfterSend: " + e.getMessage());
                }
                return responseCode;
            }
            catch (Throwable t) {
                Logger.getLogger("Raygun4Java").warning("Couldn't send exception: " + t.getMessage());
            }
        }
        return -1;
    }

    public int send(String payload) throws IOException {
        HttpURLConnection connection = this.raygunConnection.getConnection(this.apiKey);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), "UTF8");
        writer.write(payload);
        writer.flush();
        writer.close();
        connection.disconnect();
        return connection.getResponseCode();
    }

    public String toJson(Object o) {
        return new Gson().toJson(o);
    }

    public void setOnBeforeSend(IRaygunOnBeforeSend onBeforeSend) {
        this.onBeforeSend = onBeforeSend;
    }

    public void setOnAfterSend(IRaygunOnAfterSend onAfterSend) {
        this.onAfterSend = onAfterSend;
    }

    public void setOnFailedSend(IRaygunOnFailedSend onFailedSend) {
        this.onFailedSend = onFailedSend;
    }

    public IRaygunOnBeforeSend getOnBeforeSend() {
        return this.onBeforeSend;
    }

    public IRaygunOnAfterSend getOnAfterSend() {
        return this.onAfterSend;
    }

    String getVersion() {
        return this.string;
    }

    String getApiKey() {
        return this.apiKey;
    }

    public boolean shouldProcessBreadcrumbLocation() {
        return this.shouldProcessBreadcrumbLocation;
    }

    public void shouldProcessBreadcrumbLocation(boolean shouldProcessBreadcrumbLocation) {
        this.shouldProcessBreadcrumbLocation = shouldProcessBreadcrumbLocation;
    }

    public RaygunBreadcrumbMessage recordBreadcrumb(String message) {
        RaygunBreadcrumbMessage breadcrumbMessage = new RaygunBreadcrumbMessage().withMessage(message);
        this.breadcrumbs.add(RaygunClient.processBreadCrumbCodeLocation(this.shouldProcessBreadcrumbLocation, breadcrumbMessage, 3));
        return breadcrumbMessage;
    }

    public RaygunBreadcrumbMessage recordBreadcrumb(RaygunBreadcrumbMessage breadcrumb) {
        this.breadcrumbs.add(RaygunClient.processBreadCrumbCodeLocation(this.shouldProcessBreadcrumbLocation, breadcrumb, 3));
        return breadcrumb;
    }

    public RaygunClient withTag(String tag) {
        this.clientTags.add(tag);
        return this;
    }

    public Set<String> getTags() {
        return this.clientTags;
    }

    public void setTags(Set<String> tags) {
        this.clientTags = tags;
    }

    public Map<?, ?> getData() {
        return this.clientData;
    }

    public void setData(Map<?, ?> data) {
        this.clientData = data;
    }

    public RaygunClient withData(Object key, Object value) {
        this.clientData.put(key, value);
        return this;
    }

    public void ClearBreadcrumbs() {
        this.breadcrumbs.clear();
    }

    public static RaygunBreadcrumbMessage processBreadCrumbCodeLocation(boolean process, RaygunBreadcrumbMessage breadcrumbMessage, int stackFrame) {
        if (process && breadcrumbMessage.getClassName() == null) {
            StackTraceElement frame = Thread.currentThread().getStackTrace()[stackFrame];
            breadcrumbMessage.withClassName(frame.getClassName()).withMethodName(frame.getMethodName()).withLineNumber(frame.getLineNumber());
        }
        return breadcrumbMessage;
    }
}

