/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core;

import com.mindscapehq.raygun4java.core.AbstractRaygunSendEventChainFactory;
import com.mindscapehq.raygun4java.core.IRaygunClientFactory;
import com.mindscapehq.raygun4java.core.IRaygunMessageBuilder;
import com.mindscapehq.raygun4java.core.IRaygunMessageBuilderFactory;
import com.mindscapehq.raygun4java.core.IRaygunOnAfterSend;
import com.mindscapehq.raygun4java.core.IRaygunOnBeforeSend;
import com.mindscapehq.raygun4java.core.IRaygunOnFailedSend;
import com.mindscapehq.raygun4java.core.IRaygunSendEventFactory;
import com.mindscapehq.raygun4java.core.RaygunClient;
import com.mindscapehq.raygun4java.core.RaygunMessageBuilder;
import com.mindscapehq.raygun4java.core.RaygunOnAfterSendChainFactory;
import com.mindscapehq.raygun4java.core.RaygunOnBeforeSendChainFactory;
import com.mindscapehq.raygun4java.core.RaygunOnFailedSendChainFactory;
import com.mindscapehq.raygun4java.core.handlers.offlinesupport.RaygunOnFailedSendOfflineStorageHandler;
import com.mindscapehq.raygun4java.core.handlers.requestfilters.RaygunDuplicateErrorFilterFactory;
import com.mindscapehq.raygun4java.core.handlers.requestfilters.RaygunExcludeExceptionFilter;
import com.mindscapehq.raygun4java.core.handlers.requestfilters.RaygunStripWrappedExceptionFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class RaygunClientFactory
implements IRaygunClientFactory {
    protected String version;
    protected String apiKey;
    private AbstractRaygunSendEventChainFactory<IRaygunOnBeforeSend> onBeforeSendChainFactory;
    private AbstractRaygunSendEventChainFactory<IRaygunOnAfterSend> onAfterSendChainFactory;
    private AbstractRaygunSendEventChainFactory<IRaygunOnFailedSend> onFailedSendChainFactory;
    protected Set<String> factoryTags;
    protected Map factoryData;
    private RaygunClient client;
    private boolean shouldProcessBreadcrumbLocations = false;
    private IRaygunMessageBuilderFactory raygunMessageBuilderFactory = new IRaygunMessageBuilderFactory(){

        @Override
        public IRaygunMessageBuilder newMessageBuilder() {
            return new RaygunMessageBuilder();
        }
    };

    public RaygunClientFactory(String apiKey) {
        this.apiKey = apiKey;
        this.version = new RaygunMessageBuilder().setVersion(null).build().getDetails().getVersion();
        this.factoryTags = new HashSet<String>();
        this.factoryData = new WeakHashMap();
        RaygunDuplicateErrorFilterFactory duplicateErrorRecordFilterFactory = new RaygunDuplicateErrorFilterFactory();
        this.onBeforeSendChainFactory = new RaygunOnBeforeSendChainFactory().afterAll(duplicateErrorRecordFilterFactory);
        this.onAfterSendChainFactory = new RaygunOnAfterSendChainFactory().withFilterFactory(duplicateErrorRecordFilterFactory);
        this.onFailedSendChainFactory = new RaygunOnFailedSendChainFactory();
    }

    @Override
    public RaygunClientFactory withBeforeSend(IRaygunSendEventFactory<IRaygunOnBeforeSend> onBeforeSend) {
        this.onBeforeSendChainFactory.withFilterFactory(onBeforeSend);
        return this;
    }

    @Override
    public RaygunClientFactory withAfterSend(IRaygunSendEventFactory<IRaygunOnAfterSend> onAfterSend) {
        this.onAfterSendChainFactory.withFilterFactory(onAfterSend);
        return this;
    }

    @Override
    public RaygunClientFactory withFailedSend(IRaygunSendEventFactory<IRaygunOnFailedSend> onFailedSend) {
        this.onFailedSendChainFactory.withFilterFactory(onFailedSend);
        return this;
    }

    public RaygunClientFactory withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public RaygunClientFactory withVersion(String version) {
        this.version = version;
        return this;
    }

    public RaygunClientFactory withVersionFrom(Class versionFromClass) {
        this.version = this.raygunMessageBuilderFactory.newMessageBuilder().setVersionFrom(versionFromClass).build().getDetails().getVersion();
        return this;
    }

    public RaygunClientFactory withMessageBuilder(IRaygunMessageBuilderFactory messageBuilderFactory) {
        this.raygunMessageBuilderFactory = messageBuilderFactory;
        return this;
    }

    public RaygunClientFactory withOfflineStorage() {
        return this.withOfflineStorage("");
    }

    public RaygunClientFactory withOfflineStorage(String storageDir) {
        RaygunOnFailedSendOfflineStorageHandler sendOfflineStorageHandler = new RaygunOnFailedSendOfflineStorageHandler(storageDir, this.apiKey);
        this.onBeforeSendChainFactory.withFilterFactory(sendOfflineStorageHandler);
        this.onFailedSendChainFactory.withFilterFactory(sendOfflineStorageHandler);
        return this;
    }

    public RaygunClientFactory withBreadcrumbLocations() {
        this.shouldProcessBreadcrumbLocations = true;
        return this;
    }

    public RaygunClientFactory withTag(String tag) {
        this.factoryTags.add(tag);
        return this;
    }

    public Set<String> getTags() {
        return this.factoryTags;
    }

    public void setTags(Set<String> tags) {
        this.factoryTags = tags;
    }

    public Map<?, ?> getData() {
        return this.factoryData;
    }

    public void setData(Map<?, ?> data) {
        this.factoryData = data;
    }

    public RaygunClientFactory withData(Object key, Object value) {
        this.factoryData.put(key, value);
        return this;
    }

    public RaygunClientFactory withWrappedExceptionStripping(Class ... stripWrappers) {
        this.onBeforeSendChainFactory.withFilterFactory(new RaygunStripWrappedExceptionFilter(stripWrappers));
        return this;
    }

    public RaygunClientFactory withExcludedExceptions(Class ... excludedWrappers) {
        this.onBeforeSendChainFactory.withFilterFactory(new RaygunExcludeExceptionFilter(excludedWrappers));
        return this;
    }

    @Override
    public RaygunClient newClient() {
        return this.buildClient(new RaygunClient(this.apiKey));
    }

    public <T extends RaygunClient> T buildClient(T client) {
        client.setOnBeforeSend(this.onBeforeSendChainFactory.create());
        client.setOnAfterSend(this.onAfterSendChainFactory.create());
        client.setOnFailedSend(this.onFailedSendChainFactory.create());
        client.string = this.version;
        client.shouldProcessBreadcrumbLocation(this.shouldProcessBreadcrumbLocations);
        client.setTags(new HashSet<String>(this.factoryTags));
        client.setData(new WeakHashMap(this.factoryData));
        return client;
    }

    @Override
    public AbstractRaygunSendEventChainFactory<IRaygunOnBeforeSend> getRaygunOnBeforeSendChainFactory() {
        return this.onBeforeSendChainFactory;
    }

    @Override
    public AbstractRaygunSendEventChainFactory getRaygunOnAfterSendChainFactory() {
        return this.onAfterSendChainFactory;
    }

    @Override
    public AbstractRaygunSendEventChainFactory getRaygunOnFailedSendChainFactory() {
        return this.onFailedSendChainFactory;
    }
}

