/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core;

import com.mindscapehq.raygun4java.core.RaygunSettings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

public class RaygunConnection {
    private RaygunSettings raygunSettings;

    public RaygunConnection(RaygunSettings raygunSettings) {
        this.raygunSettings = raygunSettings;
    }

    public HttpURLConnection getConnection(String apiKey) throws IOException {
        HttpURLConnection connection = null;
        URL url = new URL(this.raygunSettings.getApiEndPoint());
        Proxy proxy = this.raygunSettings.getHttpProxy();
        connection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        if (this.raygunSettings.getConnectTimeout() != null) {
            connection.setConnectTimeout(this.raygunSettings.getConnectTimeout());
        }
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("X-ApiKey", apiKey);
        return connection;
    }
}

