/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core;

import com.mindscapehq.raygun4java.core.IRaygunMessageBuilder;
import com.mindscapehq.raygun4java.core.messages.RaygunBreadcrumbMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunClientMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunEnvironmentMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunErrorMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunIdentifier;
import com.mindscapehq.raygun4java.core.messages.RaygunMessage;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;

public class RaygunMessageBuilder
implements IRaygunMessageBuilder {
    protected RaygunMessage raygunMessage = new RaygunMessage();

    @Override
    public RaygunMessage build() {
        return this.raygunMessage;
    }

    public static IRaygunMessageBuilder newMessageBuilder() {
        return new RaygunMessageBuilder();
    }

    @Override
    public IRaygunMessageBuilder setMachineName(String machineName) {
        this.raygunMessage.getDetails().setMachineName(machineName);
        return this;
    }

    @Override
    public IRaygunMessageBuilder setExceptionDetails(Throwable throwable) {
        this.raygunMessage.getDetails().setError(new RaygunErrorMessage(throwable));
        return this;
    }

    @Override
    public IRaygunMessageBuilder setClientDetails() {
        this.raygunMessage.getDetails().setClient(new RaygunClientMessage());
        return this;
    }

    @Override
    public IRaygunMessageBuilder setEnvironmentDetails() {
        this.raygunMessage.getDetails().setEnvironment(new RaygunEnvironmentMessage());
        return this;
    }

    @Override
    public IRaygunMessageBuilder setVersion(String version) {
        if (version != null) {
            this.raygunMessage.getDetails().setVersion(version);
        } else {
            this.raygunMessage.getDetails().setVersion(this.ReadVersion(null));
        }
        return this;
    }

    @Override
    public IRaygunMessageBuilder setVersionFrom(Class versionFrom) {
        this.raygunMessage.getDetails().setVersion(this.ReadVersion(versionFrom));
        return this;
    }

    @Override
    public IRaygunMessageBuilder setTags(Set<String> tags) {
        this.raygunMessage.getDetails().setTags(tags);
        return this;
    }

    @Override
    public IRaygunMessageBuilder setUserCustomData(Map<?, ?> userCustomData) {
        this.raygunMessage.getDetails().setUserCustomData(userCustomData);
        return this;
    }

    @Override
    public IRaygunMessageBuilder setUser(RaygunIdentifier user) {
        this.raygunMessage.getDetails().setUser(user);
        return this;
    }

    @Override
    public IRaygunMessageBuilder setGroupingKey(String groupingKey) {
        this.raygunMessage.getDetails().setGroupingKey(groupingKey);
        return this;
    }

    @Override
    public IRaygunMessageBuilder setBreadrumbs(List<RaygunBreadcrumbMessage> breadcrumbs) {
        this.raygunMessage.getDetails().setBreadcrumbs(breadcrumbs);
        return this;
    }

    private String ReadVersion(Class readVersionFrom) {
        String mainClass;
        if (readVersionFrom == null) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement main = stack[stack.length - 1];
            mainClass = main.getClassName();
        } else {
            mainClass = readVersionFrom.getName();
        }
        try {
            Class<?> cl = this.getClass().getClassLoader().loadClass(mainClass);
            String className = cl.getSimpleName() + ".class";
            String classPath = cl.getResource(className).toString();
            String jarPath = classPath.substring(0, classPath.lastIndexOf("!") + 1);
            if (jarPath.length() > 0) {
                String manifestPath = jarPath + "/META-INF/MANIFEST.MF";
                return this.readVersionFromManifest(new URL(manifestPath).openStream());
            }
        }
        catch (Exception e) {
            Logger.getLogger("Raygun4Java").warning("Cannot read version from manifest: " + e.getMessage());
        }
        return this.noManifestVersion();
    }

    protected String readVersionFromManifest(InputStream manifestInputStream) {
        try {
            Manifest manifest = new Manifest(manifestInputStream);
            Attributes attr = manifest.getMainAttributes();
            if (attr.getValue("Specification-Version") != null) {
                return attr.getValue("Specification-Version");
            }
            if (attr.getValue("Implementation-Version") != null) {
                return attr.getValue("Implementation-Version");
            }
        }
        catch (Exception e) {
            Logger.getLogger("Raygun4Java").warning("Cannot read version from manifest: " + e.getMessage());
        }
        return this.noManifestVersion();
    }

    protected String noManifestVersion() {
        return "Not supplied";
    }
}

