/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core.handlers.offlinesupport;

import com.mindscapehq.raygun4java.core.IRaygunOnBeforeSend;
import com.mindscapehq.raygun4java.core.IRaygunOnFailedSend;
import com.mindscapehq.raygun4java.core.IRaygunSendEventFactory;
import com.mindscapehq.raygun4java.core.RaygunClient;
import com.mindscapehq.raygun4java.core.handlers.offlinesupport.RaygunSendStoredExceptions;
import com.mindscapehq.raygun4java.core.messages.RaygunMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import java.util.logging.Logger;

public class RaygunOnFailedSendOfflineStorageHandler
implements IRaygunOnFailedSend,
IRaygunOnBeforeSend,
IRaygunSendEventFactory {
    static final String fileExtension = ".raygunpayload";
    private final String apiKeyHash;
    private Random random = new Random();
    private String storageDir;
    File storage;
    boolean enabled = true;
    private boolean exceptionLogged = false;
    boolean hasStoredExceptions = true;
    private volatile Runnable sendingStoredExceptions;

    public RaygunOnFailedSendOfflineStorageHandler(String storageDir, String apiKey) {
        this.apiKeyHash = new BigInteger(String.valueOf(Math.abs(apiKey.hashCode()))).toString(36);
        this.storageDir = storageDir;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RaygunMessage onBeforeSend(RaygunClient client, RaygunMessage message) {
        if (this.enabled && this.hasStoredExceptions && this.sendingStoredExceptions == null) {
            RaygunOnFailedSendOfflineStorageHandler raygunOnFailedSendOfflineStorageHandler = this;
            synchronized (raygunOnFailedSendOfflineStorageHandler) {
                if (this.sendingStoredExceptions == null) {
                    this.sendingStoredExceptions = new RaygunSendStoredExceptions(client, this.getStorage(this.storageDir));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            RaygunOnFailedSendOfflineStorageHandler.this.sendingStoredExceptions.run();
                            RaygunOnFailedSendOfflineStorageHandler.this.sendingStoredExceptions = null;
                            RaygunOnFailedSendOfflineStorageHandler.this.hasStoredExceptions = false;
                        }
                    }).start();
                }
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String onFailedSend(RaygunClient client, String jsonPayload) {
        if (!this.enabled) {
            return jsonPayload;
        }
        OutputStream fileOutputStream = null;
        try {
            File file = this.getFile();
            if (file == null) {
                String string = jsonPayload;
                return string;
            }
            fileOutputStream = this.getOutputStream(file);
            fileOutputStream.write(jsonPayload.getBytes());
            this.exceptionLogged = false;
            this.hasStoredExceptions = true;
        }
        catch (Exception e1) {
            if (!this.exceptionLogged) {
                Logger.getLogger("Raygun4Java").warning("exception adding to offline storage: " + e1.getMessage());
                this.exceptionLogged = true;
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e1) {
                    Logger.getLogger("Raygun4Java").warning("exception closing file stream: " + e1.getMessage());
                }
            }
        }
        return jsonPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getFile() {
        try {
            File file;
            if (this.storage == null) {
                RaygunOnFailedSendOfflineStorageHandler raygunOnFailedSendOfflineStorageHandler = this;
                synchronized (raygunOnFailedSendOfflineStorageHandler) {
                    if (this.storage == null) {
                        this.storage = this.getStorage(this.storageDir);
                        if (!this.storage.exists() && !this.storage.mkdirs()) {
                            return this.disable();
                        }
                    }
                    if (!this.enabled) {
                        return this.disable();
                    }
                }
            }
            if (!(file = this.getFile(this.storage, this.random.nextInt() + fileExtension)).createNewFile()) {
                return this.disable();
            }
            return file;
        }
        catch (Exception e) {
            return this.disable();
        }
    }

    OutputStream getOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    File getStorage(String storageDir) {
        return new File(new File(storageDir).getAbsolutePath(), ".raygun_offline_storage_" + this.apiKeyHash).getAbsoluteFile();
    }

    File getFile(File storage, String name) {
        return new File(storage, name).getAbsoluteFile();
    }

    private File disable() {
        this.enabled = false;
        return null;
    }

    public IRaygunOnBeforeSend create() {
        return this;
    }
}

