/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core.handlers.requestfilters;

import com.mindscapehq.raygun4java.core.IRaygunOnBeforeSend;
import com.mindscapehq.raygun4java.core.IRaygunSendEventFactory;
import com.mindscapehq.raygun4java.core.RaygunClient;
import com.mindscapehq.raygun4java.core.messages.RaygunMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunRequestMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunRequestMessageDetails;
import java.util.Map;

public abstract class AbstractRaygunRequestMapFilter<T>
implements IRaygunOnBeforeSend,
IRaygunSendEventFactory {
    private final String[] keysToFilter;
    private String replacement = "[FILTERED]";

    public AbstractRaygunRequestMapFilter(String ... keysToFilter) {
        this.keysToFilter = keysToFilter;
    }

    public abstract Map<String, String> getMapToFilter(RaygunRequestMessage var1);

    protected void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public RaygunMessage onBeforeSend(RaygunClient client, RaygunMessage message) {
        RaygunRequestMessageDetails requestMessageDetails;
        if (message.getDetails() != null && message.getDetails() instanceof RaygunRequestMessageDetails && (requestMessageDetails = (RaygunRequestMessageDetails)message.getDetails()).getRequest() != null) {
            Map<String, String> mapToFilter = this.getMapToFilter(requestMessageDetails.getRequest());
            this.applyFilter(mapToFilter);
        }
        return message;
    }

    protected void applyFilter(Map<String, String> mapToFilter) {
        for (String key : this.keysToFilter) {
            if (!mapToFilter.containsKey(key)) continue;
            mapToFilter.put(key, this.replacement);
        }
    }

    public IRaygunOnBeforeSend create() {
        return this;
    }
}

