/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core.handlers.requestfilters;

import com.mindscapehq.raygun4java.core.IRaygunOnBeforeSend;
import com.mindscapehq.raygun4java.core.IRaygunSendEventFactory;
import com.mindscapehq.raygun4java.core.RaygunClient;
import com.mindscapehq.raygun4java.core.messages.RaygunErrorMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunMessage;

public class RaygunExcludeExceptionFilter
implements IRaygunOnBeforeSend,
IRaygunSendEventFactory<IRaygunOnBeforeSend> {
    private Class[] excludeClasses;

    public RaygunExcludeExceptionFilter(Class<?> ... excludeClasses) {
        this.excludeClasses = excludeClasses;
    }

    @Override
    public RaygunMessage onBeforeSend(RaygunClient client, RaygunMessage message) {
        if (message.getDetails() != null && message.getDetails().getError() != null) {
            for (RaygunErrorMessage error = message.getDetails().getError(); error != null && error.getThrowable() != null; error = error.getInnerError()) {
                for (Class excludeClass : this.excludeClasses) {
                    if (!excludeClass.isAssignableFrom(error.getThrowable().getClass())) continue;
                    return null;
                }
            }
        }
        return message;
    }

    @Override
    public IRaygunOnBeforeSend create() {
        return this;
    }
}

