/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core.handlers.requestfilters;

import com.mindscapehq.raygun4java.core.handlers.requestfilters.RaygunExcludeRequestFilter;
import com.mindscapehq.raygun4java.core.messages.RaygunRequestMessageDetails;
import java.util.Collections;
import java.util.HashSet;

public class RaygunRequestHttpStatusFilter
extends RaygunExcludeRequestFilter {
    public RaygunRequestHttpStatusFilter(Integer ... excludeHttpCodes) {
        super(new ExcludeHttpCodesFilter(excludeHttpCodes));
    }

    private static class ExcludeHttpCodesFilter
    implements RaygunExcludeRequestFilter.Filter {
        private HashSet<Integer> excludedCodes = new HashSet();

        private ExcludeHttpCodesFilter(Integer ... excludeHttpCodes) {
            Collections.addAll(this.excludedCodes, excludeHttpCodes);
        }

        @Override
        public boolean shouldFilterOut(RaygunRequestMessageDetails requestMessage) {
            if (requestMessage.getResponse() != null && requestMessage.getResponse().getStatusCode() != null) {
                return this.excludedCodes.contains(requestMessage.getResponse().getStatusCode());
            }
            return false;
        }
    }
}

