/*
 * Decompiled with CFR 0.152.
 */
package com.mindscapehq.raygun4java.core.handlers.requestfilters;

import com.mindscapehq.raygun4java.core.IRaygunOnBeforeSend;
import com.mindscapehq.raygun4java.core.IRaygunSendEventFactory;
import com.mindscapehq.raygun4java.core.RaygunClient;
import com.mindscapehq.raygun4java.core.messages.RaygunErrorMessage;
import com.mindscapehq.raygun4java.core.messages.RaygunMessage;

public class RaygunStripWrappedExceptionFilter
implements IRaygunOnBeforeSend,
IRaygunSendEventFactory<IRaygunOnBeforeSend> {
    private Class[] stripClasses;

    public RaygunStripWrappedExceptionFilter(Class<?> ... stripClasses) {
        this.stripClasses = stripClasses;
    }

    @Override
    public RaygunMessage onBeforeSend(RaygunClient client, RaygunMessage message) {
        if (message.getDetails() != null && message.getDetails().getError() != null && message.getDetails().getError().getInnerError() != null && message.getDetails().getError().getThrowable() != null) {
            for (Class stripClass : this.stripClasses) {
                if (!stripClass.isAssignableFrom(message.getDetails().getError().getThrowable().getClass())) continue;
                RaygunErrorMessage innerError = message.getDetails().getError().getInnerError();
                message.getDetails().setError(innerError);
                this.onBeforeSend(client, message);
                return message;
            }
        }
        return message;
    }

    @Override
    public IRaygunOnBeforeSend create() {
        return this;
    }
}

