/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.orchestrator.client;

import allocation.AllocationServiceGrpc;
import com.mineplex.orchestrator.client.AllocationClientConfig;
import com.mineplex.studio.authclient.StudioClientConfigUtil;
import com.mineplex.studio.deps.io.grpc.Grpc;
import com.mineplex.studio.deps.io.grpc.InsecureChannelCredentials;
import com.mineplex.studio.deps.io.grpc.ManagedChannel;
import com.mineplex.studio.deps.io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AllocationClient.class);
    private final ManagedChannel channel;
    private final AllocationServiceGrpc.AllocationServiceBlockingStub blockingStub;

    public AllocationClient(@NonNull AllocationClientConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        String endpoint = config.getRemoteUrl() + (String)(config.getRemotePort() != null ? ":" + config.getRemotePort() : "");
        this.channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)Grpc.newChannelBuilder(endpoint, InsecureChannelCredentials.create()).defaultServiceConfig(StudioClientConfigUtil.getServiceConfig(this.getClass()))).enableRetry()).build();
        this.blockingStub = AllocationServiceGrpc.newBlockingStub(this.channel);
    }

    @Override
    public void close() {
        try {
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Failed to close channel", (Throwable)e);
        }
    }

    @Generated
    public AllocationServiceGrpc.AllocationServiceBlockingStub getBlockingStub() {
        return this.blockingStub;
    }
}

