/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.orchestrator.client;

import agones.dev.sdk.SDKGrpc;
import agones.dev.sdk.Sdk;
import agones.dev.sdk.alpha.Alpha;
import agones.dev.sdk.alpha.SDKGrpc;
import com.mineplex.orchestrator.client.model.GameServerObject;
import com.mineplex.orchestrator.client.util.GameServerMapper;
import com.mineplex.studio.deps.io.grpc.Grpc;
import com.mineplex.studio.deps.io.grpc.InsecureChannelCredentials;
import com.mineplex.studio.deps.io.grpc.ManagedChannel;
import java.time.Duration;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestratorLocalSDK {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrchestratorLocalSDK.class);
    private final SDKGrpc.SDKBlockingStub blockingStub;
    private final SDKGrpc.SDKStub stub;
    private final SDKGrpc.SDKBlockingStub alphaBlockingStub;

    public OrchestratorLocalSDK() {
        String endpoint = "localhost:9357";
        ManagedChannel managedChannel = Grpc.newChannelBuilder("localhost:9357", InsecureChannelCredentials.create()).build();
        this.blockingStub = agones.dev.sdk.SDKGrpc.newBlockingStub(managedChannel);
        this.stub = agones.dev.sdk.SDKGrpc.newStub(managedChannel);
        this.alphaBlockingStub = SDKGrpc.newBlockingStub(managedChannel);
    }

    public void markReady() {
        this.blockingStub.ready(Sdk.Empty.newBuilder().build());
    }

    public void selfAllocate() {
        this.blockingStub.allocate(Sdk.Empty.newBuilder().build());
    }

    public void shutdown() {
        this.blockingStub.shutdown(Sdk.Empty.newBuilder().build());
    }

    public GameServerObject getGameServer() {
        return GameServerMapper.map(this.blockingStub.getGameServer(Sdk.Empty.newBuilder().build()));
    }

    public void setLabel(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.blockingStub.setLabel(Sdk.KeyValue.newBuilder().setKey(key).setValue(value).build());
    }

    public void setAnnotation(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.blockingStub.setAnnotation(Sdk.KeyValue.newBuilder().setKey(key).setValue(value).build());
    }

    public void reserve(@NonNull Duration d) {
        if (d == null) {
            throw new NullPointerException("d is marked non-null but is null");
        }
        this.blockingStub.reserve(Sdk.Duration.newBuilder().setSeconds(d.getSeconds()).build());
    }

    private Alpha.PlayerID createPlayerID(@NonNull UUID playerUUID) {
        if (playerUUID == null) {
            throw new NullPointerException("playerUUID is marked non-null but is null");
        }
        return Alpha.PlayerID.newBuilder().setPlayerID(playerUUID.toString()).build();
    }

    public void addPlayer(@NonNull UUID playerUUID) {
        if (playerUUID == null) {
            throw new NullPointerException("playerUUID is marked non-null but is null");
        }
        this.alphaBlockingStub.playerConnect(this.createPlayerID(playerUUID));
    }

    public void removePlayer(@NonNull UUID playerUUID) {
        if (playerUUID == null) {
            throw new NullPointerException("playerUUID is marked non-null but is null");
        }
        this.alphaBlockingStub.playerDisconnect(this.createPlayerID(playerUUID));
    }

    @Generated
    public SDKGrpc.SDKBlockingStub getBlockingStub() {
        return this.blockingStub;
    }

    @Generated
    public SDKGrpc.SDKStub getStub() {
        return this.stub;
    }

    @Generated
    public SDKGrpc.SDKBlockingStub getAlphaBlockingStub() {
        return this.alphaBlockingStub;
    }
}

