/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.authclient;

import com.mineplex.studio.authclient.StudioClientCredentials;
import com.mineplex.studio.deps.io.grpc.CallCredentials;
import com.mineplex.studio.deps.io.grpc.Metadata;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import lombok.Generated;

public class AbstractRefreshingClientCredentialsProvider
extends StudioClientCredentials {
    @Generated
    private final Object $lock = new Object[0];
    private final Supplier<String> credentialSupplier;
    private final Duration cacheDuration;
    private final Metadata extraHeaders = new Metadata();
    private Instant nextRefreshTime = Instant.now();

    public AbstractRefreshingClientCredentialsProvider(Supplier<String> credentialSupplier, Duration cacheDuration) {
        super("NA");
        this.credentialSupplier = credentialSupplier;
        this.cacheDuration = cacheDuration;
        this.refreshCredentials();
    }

    private static String getHeader(String token) {
        return "Bearer " + token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCredentials() {
        Object object = this.$lock;
        synchronized (object) {
            this.nextRefreshTime = Instant.now().plus(this.cacheDuration);
            String token = AbstractRefreshingClientCredentialsProvider.getHeader(this.credentialSupplier.get());
            this.extraHeaders.discardAll(Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER));
            this.extraHeaders.put(Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER), token);
        }
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        if (this.nextRefreshTime.isBefore(Instant.now())) {
            this.refreshCredentials();
        }
        applier.apply(this.extraHeaders);
    }

    @Override
    public void thisUsesUnstableApi() {
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractRefreshingClientCredentialsProvider(credentialSupplier=" + String.valueOf(this.credentialSupplier) + ", cacheDuration=" + String.valueOf(this.cacheDuration) + ", extraHeaders=" + String.valueOf(this.extraHeaders) + ", nextRefreshTime=" + String.valueOf(this.nextRefreshTime) + ")";
    }
}

