/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.authclient;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StudioClientConfigUtil {
    public static Map<String, Object> getServiceConfig(Class<?> clientClass) {
        HashMap<String, Object> retryPolicy = new HashMap<String, Object>();
        retryPolicy.put("maxAttempts", 3.0);
        retryPolicy.put("initialBackoff", "0.1s");
        retryPolicy.put("maxBackoff", "2s");
        retryPolicy.put("backoffMultiplier", 2.0);
        retryPolicy.put("retryableStatusCodes", List.of("UNAVAILABLE", "UNKNOWN"));
        HashMap<String, String> name = new HashMap<String, String>();
        name.put("service", clientClass.getName());
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        methodConfig.put("name", List.of(name));
        methodConfig.put("retryPolicy", retryPolicy);
        HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
        serviceConfig.put("methodConfig", List.of(methodConfig));
        serviceConfig.put("loadBalancingConfig", List.of(Map.of("round_robin", Map.of())));
        return serviceConfig;
    }
}

