/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.authclient;

import com.mineplex.studio.deps.io.grpc.CallCredentials;
import com.mineplex.studio.deps.io.grpc.Metadata;
import java.util.concurrent.Executor;
import lombok.Generated;
import lombok.NonNull;

public class StudioClientCredentials
extends CallCredentials {
    private final Metadata extraHeaders = new Metadata();

    public StudioClientCredentials() {
    }

    public StudioClientCredentials(@NonNull String authToken) {
        this();
        if (authToken == null) {
            throw new NullPointerException("authToken is marked non-null but is null");
        }
        String token = "Bearer " + authToken;
        this.extraHeaders.put(Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER), token);
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        applier.apply(this.extraHeaders);
    }

    @Override
    public void thisUsesUnstableApi() {
    }

    @Generated
    public String toString() {
        return "StudioClientCredentials(extraHeaders=" + String.valueOf(this.extraHeaders) + ")";
    }
}

