/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.chatfilter.client;

import com.mineplex.studio.chatfilter.client.ChatFilterClientConfig;
import com.mineplex.studio.chatfilter.contracts.ChatFilterGrpc;
import com.mineplex.studio.deps.io.grpc.Grpc;
import com.mineplex.studio.deps.io.grpc.InsecureChannelCredentials;
import com.mineplex.studio.deps.io.grpc.ManagedChannel;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatFilterClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ChatFilterClient.class);
    private final ManagedChannel channel;
    private final ChatFilterGrpc.ChatFilterBlockingStub blockingStub;

    public ChatFilterClient(@NonNull ChatFilterClientConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        String endpoint = config.getRemoteUrl() + (String)(config.getRemotePort() != null ? ":" + config.getRemotePort() : "");
        this.channel = Grpc.newChannelBuilder(endpoint, InsecureChannelCredentials.create()).build();
        this.blockingStub = ChatFilterGrpc.newBlockingStub(this.channel);
    }

    @Override
    public void close() {
        try {
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Failed to close channel", (Throwable)e);
        }
    }

    public ChatFilterGrpc.ChatFilterBlockingStub getBlockingStub() {
        return this.blockingStub;
    }
}

