/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.data.client;

import com.mineplex.studio.authclient.StudioClientConfigUtil;
import com.mineplex.studio.authclient.StudioClientCredentials;
import com.mineplex.studio.data.client.CustomDataStoreClientConfig;
import com.mineplex.studio.data.contract.CustomDataStoreGrpc;
import com.mineplex.studio.deps.io.grpc.Grpc;
import com.mineplex.studio.deps.io.grpc.InsecureChannelCredentials;
import com.mineplex.studio.deps.io.grpc.ManagedChannel;
import com.mineplex.studio.deps.io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDataStoreClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomDataStoreClient.class);
    private final ManagedChannel channel;
    private final CustomDataStoreGrpc.CustomDataStoreBlockingStub blockingStub;

    public CustomDataStoreClient(@NonNull CustomDataStoreClientConfig config, @NonNull StudioClientCredentials studioClientCredentials) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (studioClientCredentials == null) {
            throw new NullPointerException("studioClientCredentials is marked non-null but is null");
        }
        String endpoint = config.getRemoteUrl() + (String)(config.getRemotePort() != null ? ":" + config.getRemotePort() : "");
        this.channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)Grpc.newChannelBuilder(endpoint, InsecureChannelCredentials.create()).defaultServiceConfig(StudioClientConfigUtil.getServiceConfig(this.getClass()))).enableRetry()).build();
        this.blockingStub = (CustomDataStoreGrpc.CustomDataStoreBlockingStub)CustomDataStoreGrpc.newBlockingStub(this.channel).withCallCredentials(studioClientCredentials);
    }

    @Override
    public void close() {
        try {
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Failed to close channel", (Throwable)e);
        }
    }

    @Generated
    public CustomDataStoreGrpc.CustomDataStoreBlockingStub getBlockingStub() {
        return this.blockingStub;
    }
}

