/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common;

import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.CollectionMappingStrategy;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.Mapper;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.Named;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.factory.Mappers;
import com.mineplex.studio.dataplane.contracts.Uuid;
import com.mineplex.studio.deps.com.google.protobuf.Duration;
import com.mineplex.studio.deps.com.google.protobuf.LazyStringArrayList;
import com.mineplex.studio.deps.com.google.protobuf.ProtocolStringList;
import com.mineplex.studio.deps.com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED)
public interface CommonGrpcMapper {
    public static final CommonGrpcMapper INSTANCE = Mappers.getMapper(CommonGrpcMapper.class);

    @Named(value="grpcTimestampToInstant")
    default public Instant grpcTimestampToInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    @Named(value="optionalInstantToGrpcTimestamp")
    default public Timestamp optionalInstantToGrpcTimestamp(Optional<Instant> instantOpt) {
        if (instantOpt == null || instantOpt.isEmpty()) {
            return null;
        }
        return this.instantToGrpcTimestamp(instantOpt.get());
    }

    @Named(value="instantToGrpcTimestamp")
    default public Timestamp instantToGrpcTimestamp(Instant instant) {
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    @Named(value="grpcDurationToDuration")
    default public java.time.Duration grpcDurationToDuration(Duration duration) {
        return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
    }

    @Named(value="durationToGrpcDuration")
    default public Duration durationToGrpcDuration(java.time.Duration duration) {
        return Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano()).build();
    }

    @Named(value="protocolStringListToStringSet")
    default public Set<String> protocolStringListToStringSet(ProtocolStringList stringList) {
        return new HashSet<String>(stringList);
    }

    @Named(value="stringListToProtocolString")
    default public ProtocolStringList stringListToProtocolStringList(List<String> list) {
        return new LazyStringArrayList(list);
    }

    @Named(value="uuidToGrpcUuid")
    default public Uuid uuidToGrpcUuid(UUID uuid) {
        return Uuid.newBuilder().setHigh64(uuid.getMostSignificantBits()).setLow64(uuid.getLeastSignificantBits()).build();
    }

    @Named(value="grpcUuidToUuid")
    default public UUID grpcUuidToUuid(Uuid grpcUuid) {
        return new UUID(grpcUuid.getHigh64(), grpcUuid.getLow64());
    }
}

