/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.chat.log;

import com.mineplex.studio.dataplane.common.CommonGrpcMapper;
import com.mineplex.studio.dataplane.common.chat.PlayerChatSource;
import com.mineplex.studio.dataplane.common.chat.log.PlayerChatLog;
import com.mineplex.studio.dataplane.common.chat.log.PlayerChatLogGrpcMapper;
import com.mineplex.studio.dataplane.contracts.PlayerChatLog;
import com.mineplex.studio.deps.com.google.protobuf.ProtocolStringList;
import java.util.LinkedHashSet;

public class PlayerChatLogGrpcMapperImpl
implements PlayerChatLogGrpcMapper {
    private final CommonGrpcMapper commonGrpcMapper = CommonGrpcMapper.INSTANCE;

    @Override
    public PlayerChatLog grpcPlayerChatLogToPlayerChatLog(com.mineplex.studio.dataplane.contracts.PlayerChatLog playerChatLog) {
        if (playerChatLog == null) {
            return null;
        }
        PlayerChatLog.PlayerChatLogBuilder playerChatLog1 = PlayerChatLog.builder();
        if (playerChatLog.hasTimestamp()) {
            playerChatLog1.timestamp(this.commonGrpcMapper.grpcTimestampToInstant(playerChatLog.getTimestamp()));
        }
        playerChatLog1.id(playerChatLog.getId());
        playerChatLog1.playerId(playerChatLog.getPlayerId());
        playerChatLog1.projectId(playerChatLog.getProjectId());
        playerChatLog1.serverCommonName(playerChatLog.getServerCommonName());
        playerChatLog1.rawMessage(playerChatLog.getRawMessage());
        playerChatLog1.displayMessage(playerChatLog.getDisplayMessage());
        ProtocolStringList protocolStringList = playerChatLog.getAudiencesList();
        if (protocolStringList != null) {
            playerChatLog1.audiences(new LinkedHashSet<String>(protocolStringList));
        }
        playerChatLog1.messageType(playerChatLog.getMessageType());
        playerChatLog1.source(this.grpcPlayerChatSourceToPlayerChatSource(playerChatLog.getSource()));
        playerChatLog1.cancelled(playerChatLog.getCancelled());
        return playerChatLog1.build();
    }

    @Override
    public PlayerChatSource grpcPlayerChatSourceToPlayerChatSource(com.mineplex.studio.dataplane.contracts.PlayerChatSource playerChatSource) {
        if (playerChatSource == null) {
            return null;
        }
        return switch (playerChatSource) {
            case com.mineplex.studio.dataplane.contracts.PlayerChatSource.UNRECOGNIZED -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(playerChatSource));
            case com.mineplex.studio.dataplane.contracts.PlayerChatSource.GAME -> PlayerChatSource.GAME;
            case com.mineplex.studio.dataplane.contracts.PlayerChatSource.PROXY -> PlayerChatSource.PROXY;
            case com.mineplex.studio.dataplane.contracts.PlayerChatSource.PLAYER_CHAT_SOURCE_UNSPECIFIED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(playerChatSource));
        };
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerChatLog playerChatLogToGrpcPlayerChatLog(PlayerChatLog playerChatLog) {
        if (playerChatLog == null) {
            return null;
        }
        PlayerChatLog.Builder playerChatLog1 = com.mineplex.studio.dataplane.contracts.PlayerChatLog.newBuilder();
        playerChatLog1.setTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(playerChatLog.getTimestamp()));
        playerChatLog1.setId(playerChatLog.getId());
        playerChatLog1.setPlayerId(playerChatLog.getPlayerId());
        playerChatLog1.setProjectId(playerChatLog.getProjectId());
        playerChatLog1.setServerCommonName(playerChatLog.getServerCommonName());
        playerChatLog1.setRawMessage(playerChatLog.getRawMessage());
        playerChatLog1.setDisplayMessage(playerChatLog.getDisplayMessage());
        playerChatLog1.setMessageType(playerChatLog.getMessageType());
        playerChatLog1.setSource(this.playerChatSourceToPlayerChatSource(playerChatLog.getSource()));
        playerChatLog1.setCancelled(playerChatLog.isCancelled());
        if (playerChatLog.getAudiences() != null) {
            for (String audience : playerChatLog.getAudiences()) {
                playerChatLog1.addAudiences(audience);
            }
        }
        return playerChatLog1.build();
    }

    protected com.mineplex.studio.dataplane.contracts.PlayerChatSource playerChatSourceToPlayerChatSource(PlayerChatSource playerChatSource) {
        if (playerChatSource == null) {
            return com.mineplex.studio.dataplane.contracts.PlayerChatSource.PLAYER_CHAT_SOURCE_UNSPECIFIED;
        }
        return switch (playerChatSource) {
            case PlayerChatSource.GAME -> com.mineplex.studio.dataplane.contracts.PlayerChatSource.GAME;
            case PlayerChatSource.PROXY -> com.mineplex.studio.dataplane.contracts.PlayerChatSource.PROXY;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)playerChatSource));
        };
    }
}

