/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.chat.snapshot;

import com.mineplex.studio.dataplane.common.CommonGrpcMapper;
import com.mineplex.studio.dataplane.common.chat.log.PlayerChatLog;
import com.mineplex.studio.dataplane.common.chat.log.PlayerChatLogGrpcMapper;
import com.mineplex.studio.dataplane.common.chat.snapshot.PlayerChatSnapshot;
import com.mineplex.studio.dataplane.common.chat.snapshot.PlayerChatSnapshotGrpcMapper;
import com.mineplex.studio.dataplane.contracts.ChatSnapshot;
import java.util.ArrayList;
import java.util.List;

public class PlayerChatSnapshotGrpcMapperImpl
implements PlayerChatSnapshotGrpcMapper {
    private final CommonGrpcMapper commonGrpcMapper = CommonGrpcMapper.INSTANCE;
    private final PlayerChatLogGrpcMapper playerChatLogGrpcMapper = PlayerChatLogGrpcMapper.INSTANCE;

    @Override
    public PlayerChatSnapshot grpcChatSnapshotToPlayerChatSnapshot(ChatSnapshot chatSnapshot) {
        if (chatSnapshot == null) {
            return null;
        }
        PlayerChatSnapshot.PlayerChatSnapshotBuilder playerChatSnapshot = PlayerChatSnapshot.builder();
        if (chatSnapshot.hasCreatedAt()) {
            playerChatSnapshot.createdAt(this.commonGrpcMapper.grpcTimestampToInstant(chatSnapshot.getCreatedAt()));
        }
        if (chatSnapshot.hasStartTime()) {
            playerChatSnapshot.startTime(this.commonGrpcMapper.grpcTimestampToInstant(chatSnapshot.getStartTime()));
        }
        if (chatSnapshot.hasEndTime()) {
            playerChatSnapshot.endTime(this.commonGrpcMapper.grpcTimestampToInstant(chatSnapshot.getEndTime()));
        }
        playerChatSnapshot.id(chatSnapshot.getId());
        playerChatSnapshot.projectId(chatSnapshot.getProjectId());
        playerChatSnapshot.serverCommonName(chatSnapshot.getServerCommonName());
        if (chatSnapshot.hasPlayerId()) {
            playerChatSnapshot.playerId(chatSnapshot.getPlayerId());
        }
        playerChatSnapshot.chatLogs(this.playerChatLogListToPlayerChatLogList(chatSnapshot.getChatLogsList()));
        return playerChatSnapshot.build();
    }

    @Override
    public ChatSnapshot playerChatSnapshotToGrpcChatSnapshot(PlayerChatSnapshot playerChatSnapshot) {
        if (playerChatSnapshot == null) {
            return null;
        }
        ChatSnapshot.Builder chatSnapshot = ChatSnapshot.newBuilder();
        chatSnapshot.setCreatedAt(this.commonGrpcMapper.instantToGrpcTimestamp(playerChatSnapshot.getCreatedAt()));
        chatSnapshot.setStartTime(this.commonGrpcMapper.instantToGrpcTimestamp(playerChatSnapshot.getStartTime()));
        chatSnapshot.setEndTime(this.commonGrpcMapper.instantToGrpcTimestamp(playerChatSnapshot.getEndTime()));
        chatSnapshot.setId(playerChatSnapshot.getId());
        chatSnapshot.setProjectId(playerChatSnapshot.getProjectId());
        chatSnapshot.setServerCommonName(playerChatSnapshot.getServerCommonName());
        chatSnapshot.setPlayerId(playerChatSnapshot.getPlayerId());
        if (playerChatSnapshot.getChatLogs() != null) {
            for (PlayerChatLog chatLog : playerChatSnapshot.getChatLogs()) {
                chatSnapshot.addChatLogs(this.playerChatLogGrpcMapper.playerChatLogToGrpcPlayerChatLog(chatLog));
            }
        }
        return chatSnapshot.build();
    }

    protected List<PlayerChatLog> playerChatLogListToPlayerChatLogList(List<com.mineplex.studio.dataplane.contracts.PlayerChatLog> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PlayerChatLog> list1 = new ArrayList<PlayerChatLog>(list.size());
        for (com.mineplex.studio.dataplane.contracts.PlayerChatLog playerChatLog : list) {
            list1.add(this.playerChatLogGrpcMapper.grpcPlayerChatLogToPlayerChatLog(playerChatLog));
        }
        return list1;
    }
}

