/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.friend;

import com.mineplex.studio.dataplane.common.CommonGrpcMapper;
import com.mineplex.studio.dataplane.common.CommonMapper;
import com.mineplex.studio.dataplane.common.friend.FriendGrpcMapper;
import com.mineplex.studio.dataplane.common.friend.model.PlayerFriendInviteStatus;
import com.mineplex.studio.dataplane.common.friend.model.PlayerFriendProfile;
import com.mineplex.studio.dataplane.common.friend.model.PlayerFriendStatus;
import com.mineplex.studio.dataplane.common.location.ServerLocationGrpcMapper;
import com.mineplex.studio.dataplane.common.profile.ProfileGrpcMapper;
import com.mineplex.studio.dataplane.contracts.GetPlayerFriendProfileResponse;
import com.mineplex.studio.dataplane.contracts.PlayerFriendInviteStatus;
import com.mineplex.studio.dataplane.contracts.PlayerFriendStatus;

public class FriendGrpcMapperImpl
implements FriendGrpcMapper {
    private final ProfileGrpcMapper profileGrpcMapper = ProfileGrpcMapper.INSTANCE;
    private final ServerLocationGrpcMapper serverLocationGrpcMapper = ServerLocationGrpcMapper.INSTANCE;
    private final CommonGrpcMapper commonGrpcMapper = CommonGrpcMapper.INSTANCE;
    private final CommonMapper commonMapper = CommonMapper.INSTANCE;

    @Override
    public PlayerFriendStatus grpcPlayerFriendStatusToPlayerFriendStatus(com.mineplex.studio.dataplane.contracts.PlayerFriendStatus grpcPlayerFriendStatus) {
        if (grpcPlayerFriendStatus == null) {
            return null;
        }
        PlayerFriendStatus.PlayerFriendStatusBuilder playerFriendStatus = PlayerFriendStatus.builder();
        playerFriendStatus.online(grpcPlayerFriendStatus.getIsOnline());
        if (grpcPlayerFriendStatus.hasOnlineStateUpdateTimestamp()) {
            playerFriendStatus.lastOnlineAt(this.commonGrpcMapper.grpcTimestampToInstant(grpcPlayerFriendStatus.getOnlineStateUpdateTimestamp()));
        }
        if (grpcPlayerFriendStatus.hasFriendAddedTimestamp()) {
            playerFriendStatus.addedAt(this.commonGrpcMapper.grpcTimestampToInstant(grpcPlayerFriendStatus.getFriendAddedTimestamp()));
        }
        if (grpcPlayerFriendStatus.hasPlayer()) {
            playerFriendStatus.player(this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcPlayerFriendStatus.getPlayer()));
        }
        if (grpcPlayerFriendStatus.hasFriendPlayer()) {
            playerFriendStatus.friendPlayer(this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcPlayerFriendStatus.getFriendPlayer()));
        }
        if (grpcPlayerFriendStatus.hasServerLocation()) {
            playerFriendStatus.serverLocation(this.serverLocationGrpcMapper.grpcServerLocationToServerLocation(grpcPlayerFriendStatus.getServerLocation()));
        }
        return playerFriendStatus.build();
    }

    @Override
    public PlayerFriendInviteStatus grpcPlayerFriendInviteStatusToPlayerFriendInviteStatus(com.mineplex.studio.dataplane.contracts.PlayerFriendInviteStatus grpcPlayerFriendInviteStatus) {
        if (grpcPlayerFriendInviteStatus == null) {
            return null;
        }
        PlayerFriendInviteStatus.PlayerFriendInviteStatusBuilder playerFriendInviteStatus = PlayerFriendInviteStatus.builder();
        if (grpcPlayerFriendInviteStatus.hasInviteSentTimestamp()) {
            playerFriendInviteStatus.inviteTime(this.commonGrpcMapper.grpcTimestampToInstant(grpcPlayerFriendInviteStatus.getInviteSentTimestamp()));
        }
        if (grpcPlayerFriendInviteStatus.hasPlayer()) {
            playerFriendInviteStatus.player(this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcPlayerFriendInviteStatus.getPlayer()));
        }
        if (grpcPlayerFriendInviteStatus.hasFriendPlayer()) {
            playerFriendInviteStatus.friendPlayer(this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcPlayerFriendInviteStatus.getFriendPlayer()));
        }
        return playerFriendInviteStatus.build();
    }

    @Override
    public PlayerFriendProfile grpcGetPlayerFriendProfileResponseToPlayerFriendProfile(GetPlayerFriendProfileResponse grpcGetPlayerFriendProfileResponse) {
        if (grpcGetPlayerFriendProfileResponse == null) {
            return null;
        }
        PlayerFriendProfile.PlayerFriendProfileBuilder playerFriendProfile = PlayerFriendProfile.builder();
        playerFriendProfile.outgoingFriendRequests(this.grpcPlayerFriendInviteStatusToMapByFriendPlayerId(grpcGetPlayerFriendProfileResponse.getOutgoingPlayerFriendInviteStatusesList()));
        playerFriendProfile.incomingFriendRequests(this.grpcPlayerFriendInviteStatusToMapByFriendPlayerId(grpcGetPlayerFriendProfileResponse.getIncomingPlayerFriendInviteStatusesList()));
        playerFriendProfile.friends(this.grpcPlayerFriendStatusToMapByFriendPlayerId(grpcGetPlayerFriendProfileResponse.getPlayerFriendStatusesList()));
        return playerFriendProfile.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerFriendStatus playerFriendStatusToGrpcPlayerFriendStatus(PlayerFriendStatus playerFriendStatus) {
        if (playerFriendStatus == null) {
            return null;
        }
        PlayerFriendStatus.Builder playerFriendStatus1 = com.mineplex.studio.dataplane.contracts.PlayerFriendStatus.newBuilder();
        playerFriendStatus1.setIsOnline(playerFriendStatus.isOnline());
        playerFriendStatus1.setFriendAddedTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(playerFriendStatus.getAddedAt()));
        playerFriendStatus1.setOnlineStateUpdateTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(playerFriendStatus.getLastOnlineAt()));
        if (playerFriendStatus.hasServerLocation()) {
            playerFriendStatus1.setServerLocation(this.serverLocationGrpcMapper.serverLocationToGrpcServerLocation(this.commonMapper.unwrapOptional(playerFriendStatus.getServerLocation())));
        }
        playerFriendStatus1.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(playerFriendStatus.getPlayer()));
        playerFriendStatus1.setFriendPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(playerFriendStatus.getFriendPlayer()));
        return playerFriendStatus1.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerFriendInviteStatus playerFriendInviteStatusToGrpcPlayerFriendInviteStatus(PlayerFriendInviteStatus playerFriendInviteStatus) {
        if (playerFriendInviteStatus == null) {
            return null;
        }
        PlayerFriendInviteStatus.Builder playerFriendInviteStatus1 = com.mineplex.studio.dataplane.contracts.PlayerFriendInviteStatus.newBuilder();
        playerFriendInviteStatus1.setInviteSentTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(playerFriendInviteStatus.getInviteTime()));
        playerFriendInviteStatus1.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(playerFriendInviteStatus.getPlayer()));
        playerFriendInviteStatus1.setFriendPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(playerFriendInviteStatus.getFriendPlayer()));
        return playerFriendInviteStatus1.build();
    }
}

