/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.friend.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.friend.model.PlayerFriendInviteStatus;
import com.mineplex.studio.dataplane.common.friend.model.PlayerFriendStatus;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PlayerFriendProfileBuilder.class)
public final class PlayerFriendProfile {
    @NonNull
    private final Map<UUID, PlayerFriendStatus> friends;
    @NonNull
    private final Map<UUID, PlayerFriendInviteStatus> outgoingFriendRequests;
    @NonNull
    private final Map<UUID, PlayerFriendInviteStatus> incomingFriendRequests;

    public boolean isFriend(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return this.friends.containsKey(playerId);
    }

    public void addFriend(@NonNull PlayerFriendStatus friendStatus) {
        if (friendStatus == null) {
            throw new NullPointerException("friendStatus is marked non-null but is null");
        }
        this.friends.put(friendStatus.getFriendPlayer().getId(), friendStatus);
        this.removeIncomingFriendRequest(friendStatus.getFriendPlayer().getId());
        this.removeOutgoingFriendRequest(friendStatus.getFriendPlayer().getId());
    }

    @NonNull
    public Optional<PlayerFriendStatus> getFriend(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return Optional.ofNullable(this.friends.get(playerId));
    }

    public boolean removeFriend(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return this.friends.remove(playerId) != null;
    }

    public boolean hasOutgoingFriendRequest(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return this.outgoingFriendRequests.containsKey(playerId);
    }

    public void addOutgoingFriendRequest(@NonNull PlayerFriendInviteStatus friendInviteStatus) {
        if (friendInviteStatus == null) {
            throw new NullPointerException("friendInviteStatus is marked non-null but is null");
        }
        this.outgoingFriendRequests.put(friendInviteStatus.getFriendPlayer().getId(), friendInviteStatus);
    }

    @NonNull
    public Optional<PlayerFriendInviteStatus> getOutgoingFriendRequestStatus(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return Optional.ofNullable(this.outgoingFriendRequests.get(playerId));
    }

    public boolean removeOutgoingFriendRequest(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return this.outgoingFriendRequests.remove(playerId) != null;
    }

    public boolean hasIncomingFriendRequest(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return this.incomingFriendRequests.containsKey(playerId);
    }

    public void addIncomingFriendRequest(@NonNull PlayerFriendInviteStatus friendInviteStatus) {
        if (friendInviteStatus == null) {
            throw new NullPointerException("friendInviteStatus is marked non-null but is null");
        }
        this.incomingFriendRequests.put(friendInviteStatus.getFriendPlayer().getId(), friendInviteStatus);
    }

    @NonNull
    public Optional<PlayerFriendInviteStatus> getIncomingFriendRequestStatus(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return Optional.ofNullable(this.incomingFriendRequests.get(playerId));
    }

    public boolean removeIncomingFriendRequest(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return this.incomingFriendRequests.remove(playerId) != null;
    }

    @Generated
    PlayerFriendProfile(@NonNull Map<UUID, PlayerFriendStatus> friends, @NonNull Map<UUID, PlayerFriendInviteStatus> outgoingFriendRequests, @NonNull Map<UUID, PlayerFriendInviteStatus> incomingFriendRequests) {
        if (friends == null) {
            throw new NullPointerException("friends is marked non-null but is null");
        }
        if (outgoingFriendRequests == null) {
            throw new NullPointerException("outgoingFriendRequests is marked non-null but is null");
        }
        if (incomingFriendRequests == null) {
            throw new NullPointerException("incomingFriendRequests is marked non-null but is null");
        }
        this.friends = friends;
        this.outgoingFriendRequests = outgoingFriendRequests;
        this.incomingFriendRequests = incomingFriendRequests;
    }

    @Generated
    public static PlayerFriendProfileBuilder builder() {
        return new PlayerFriendProfileBuilder();
    }

    @Generated
    public PlayerFriendProfileBuilder toBuilder() {
        return new PlayerFriendProfileBuilder().friends(this.friends).outgoingFriendRequests(this.outgoingFriendRequests).incomingFriendRequests(this.incomingFriendRequests);
    }

    @NonNull
    @Generated
    public Map<UUID, PlayerFriendStatus> getFriends() {
        return this.friends;
    }

    @NonNull
    @Generated
    public Map<UUID, PlayerFriendInviteStatus> getOutgoingFriendRequests() {
        return this.outgoingFriendRequests;
    }

    @NonNull
    @Generated
    public Map<UUID, PlayerFriendInviteStatus> getIncomingFriendRequests() {
        return this.incomingFriendRequests;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerFriendProfile)) {
            return false;
        }
        PlayerFriendProfile other = (PlayerFriendProfile)o;
        Map<UUID, PlayerFriendStatus> this$friends = this.getFriends();
        Map<UUID, PlayerFriendStatus> other$friends = other.getFriends();
        if (this$friends == null ? other$friends != null : !((Object)this$friends).equals(other$friends)) {
            return false;
        }
        Map<UUID, PlayerFriendInviteStatus> this$outgoingFriendRequests = this.getOutgoingFriendRequests();
        Map<UUID, PlayerFriendInviteStatus> other$outgoingFriendRequests = other.getOutgoingFriendRequests();
        if (this$outgoingFriendRequests == null ? other$outgoingFriendRequests != null : !((Object)this$outgoingFriendRequests).equals(other$outgoingFriendRequests)) {
            return false;
        }
        Map<UUID, PlayerFriendInviteStatus> this$incomingFriendRequests = this.getIncomingFriendRequests();
        Map<UUID, PlayerFriendInviteStatus> other$incomingFriendRequests = other.getIncomingFriendRequests();
        return !(this$incomingFriendRequests == null ? other$incomingFriendRequests != null : !((Object)this$incomingFriendRequests).equals(other$incomingFriendRequests));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<UUID, PlayerFriendStatus> $friends = this.getFriends();
        result = result * 59 + ($friends == null ? 43 : ((Object)$friends).hashCode());
        Map<UUID, PlayerFriendInviteStatus> $outgoingFriendRequests = this.getOutgoingFriendRequests();
        result = result * 59 + ($outgoingFriendRequests == null ? 43 : ((Object)$outgoingFriendRequests).hashCode());
        Map<UUID, PlayerFriendInviteStatus> $incomingFriendRequests = this.getIncomingFriendRequests();
        result = result * 59 + ($incomingFriendRequests == null ? 43 : ((Object)$incomingFriendRequests).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlayerFriendProfile(friends=" + String.valueOf(this.getFriends()) + ", outgoingFriendRequests=" + String.valueOf(this.getOutgoingFriendRequests()) + ", incomingFriendRequests=" + String.valueOf(this.getIncomingFriendRequests()) + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PlayerFriendProfileBuilder {
        @Generated
        private Map<UUID, PlayerFriendStatus> friends;
        @Generated
        private Map<UUID, PlayerFriendInviteStatus> outgoingFriendRequests;
        @Generated
        private Map<UUID, PlayerFriendInviteStatus> incomingFriendRequests;

        @Generated
        PlayerFriendProfileBuilder() {
        }

        @Generated
        public PlayerFriendProfileBuilder friends(@NonNull Map<UUID, PlayerFriendStatus> friends) {
            if (friends == null) {
                throw new NullPointerException("friends is marked non-null but is null");
            }
            this.friends = friends;
            return this;
        }

        @Generated
        public PlayerFriendProfileBuilder outgoingFriendRequests(@NonNull Map<UUID, PlayerFriendInviteStatus> outgoingFriendRequests) {
            if (outgoingFriendRequests == null) {
                throw new NullPointerException("outgoingFriendRequests is marked non-null but is null");
            }
            this.outgoingFriendRequests = outgoingFriendRequests;
            return this;
        }

        @Generated
        public PlayerFriendProfileBuilder incomingFriendRequests(@NonNull Map<UUID, PlayerFriendInviteStatus> incomingFriendRequests) {
            if (incomingFriendRequests == null) {
                throw new NullPointerException("incomingFriendRequests is marked non-null but is null");
            }
            this.incomingFriendRequests = incomingFriendRequests;
            return this;
        }

        @Generated
        public PlayerFriendProfile build() {
            return new PlayerFriendProfile(this.friends, this.outgoingFriendRequests, this.incomingFriendRequests);
        }

        @Generated
        public String toString() {
            return "PlayerFriendProfile.PlayerFriendProfileBuilder(friends=" + String.valueOf(this.friends) + ", outgoingFriendRequests=" + String.valueOf(this.outgoingFriendRequests) + ", incomingFriendRequests=" + String.valueOf(this.incomingFriendRequests) + ")";
        }
    }
}

