/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.friend.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.location.model.ServerLocation;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PlayerFriendStatusBuilder.class)
public final class PlayerFriendStatus {
    @NonNull
    private final PlayerIdentity player;
    @NonNull
    private final PlayerIdentity friendPlayer;
    @NonNull
    private final Instant addedAt;
    private final boolean online;
    @NonNull
    private final Instant lastOnlineAt;
    @Nullable
    private final ServerLocation serverLocation;

    public boolean hasServerLocation() {
        return this.serverLocation != null;
    }

    @NonNull
    public Optional<ServerLocation> getServerLocation() {
        return Optional.ofNullable(this.serverLocation);
    }

    @NonNull
    public PlayerFriendStatus swapPlayers() {
        return this.toBuilder().player(this.friendPlayer).friendPlayer(this.player).build();
    }

    @Generated
    PlayerFriendStatus(@NonNull PlayerIdentity player, @NonNull PlayerIdentity friendPlayer, @NonNull Instant addedAt, boolean online, @NonNull Instant lastOnlineAt, @Nullable ServerLocation serverLocation) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (friendPlayer == null) {
            throw new NullPointerException("friendPlayer is marked non-null but is null");
        }
        if (addedAt == null) {
            throw new NullPointerException("addedAt is marked non-null but is null");
        }
        if (lastOnlineAt == null) {
            throw new NullPointerException("lastOnlineAt is marked non-null but is null");
        }
        this.player = player;
        this.friendPlayer = friendPlayer;
        this.addedAt = addedAt;
        this.online = online;
        this.lastOnlineAt = lastOnlineAt;
        this.serverLocation = serverLocation;
    }

    @Generated
    public static PlayerFriendStatusBuilder builder() {
        return new PlayerFriendStatusBuilder();
    }

    @Generated
    public PlayerFriendStatusBuilder toBuilder() {
        return new PlayerFriendStatusBuilder().player(this.player).friendPlayer(this.friendPlayer).addedAt(this.addedAt).online(this.online).lastOnlineAt(this.lastOnlineAt).serverLocation(this.serverLocation);
    }

    @NonNull
    @Generated
    public PlayerIdentity getPlayer() {
        return this.player;
    }

    @NonNull
    @Generated
    public PlayerIdentity getFriendPlayer() {
        return this.friendPlayer;
    }

    @NonNull
    @Generated
    public Instant getAddedAt() {
        return this.addedAt;
    }

    @Generated
    public boolean isOnline() {
        return this.online;
    }

    @NonNull
    @Generated
    public Instant getLastOnlineAt() {
        return this.lastOnlineAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerFriendStatus)) {
            return false;
        }
        PlayerFriendStatus other = (PlayerFriendStatus)o;
        if (this.isOnline() != other.isOnline()) {
            return false;
        }
        PlayerIdentity this$player = this.getPlayer();
        PlayerIdentity other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        PlayerIdentity this$friendPlayer = this.getFriendPlayer();
        PlayerIdentity other$friendPlayer = other.getFriendPlayer();
        if (this$friendPlayer == null ? other$friendPlayer != null : !((Object)this$friendPlayer).equals(other$friendPlayer)) {
            return false;
        }
        Instant this$addedAt = this.getAddedAt();
        Instant other$addedAt = other.getAddedAt();
        if (this$addedAt == null ? other$addedAt != null : !((Object)this$addedAt).equals(other$addedAt)) {
            return false;
        }
        Instant this$lastOnlineAt = this.getLastOnlineAt();
        Instant other$lastOnlineAt = other.getLastOnlineAt();
        if (this$lastOnlineAt == null ? other$lastOnlineAt != null : !((Object)this$lastOnlineAt).equals(other$lastOnlineAt)) {
            return false;
        }
        Optional<ServerLocation> this$serverLocation = this.getServerLocation();
        Optional<ServerLocation> other$serverLocation = other.getServerLocation();
        return !(this$serverLocation == null ? other$serverLocation != null : !((Object)this$serverLocation).equals(other$serverLocation));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnline() ? 79 : 97);
        PlayerIdentity $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : ((Object)$player).hashCode());
        PlayerIdentity $friendPlayer = this.getFriendPlayer();
        result = result * 59 + ($friendPlayer == null ? 43 : ((Object)$friendPlayer).hashCode());
        Instant $addedAt = this.getAddedAt();
        result = result * 59 + ($addedAt == null ? 43 : ((Object)$addedAt).hashCode());
        Instant $lastOnlineAt = this.getLastOnlineAt();
        result = result * 59 + ($lastOnlineAt == null ? 43 : ((Object)$lastOnlineAt).hashCode());
        Optional<ServerLocation> $serverLocation = this.getServerLocation();
        result = result * 59 + ($serverLocation == null ? 43 : ((Object)$serverLocation).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlayerFriendStatus(player=" + String.valueOf(this.getPlayer()) + ", friendPlayer=" + String.valueOf(this.getFriendPlayer()) + ", addedAt=" + String.valueOf(this.getAddedAt()) + ", online=" + this.isOnline() + ", lastOnlineAt=" + String.valueOf(this.getLastOnlineAt()) + ", serverLocation=" + String.valueOf(this.getServerLocation()) + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PlayerFriendStatusBuilder {
        @Generated
        private PlayerIdentity player;
        @Generated
        private PlayerIdentity friendPlayer;
        @Generated
        private Instant addedAt;
        @Generated
        private boolean online;
        @Generated
        private Instant lastOnlineAt;
        @Generated
        private ServerLocation serverLocation;

        @Generated
        PlayerFriendStatusBuilder() {
        }

        @Generated
        public PlayerFriendStatusBuilder player(@NonNull PlayerIdentity player) {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.player = player;
            return this;
        }

        @Generated
        public PlayerFriendStatusBuilder friendPlayer(@NonNull PlayerIdentity friendPlayer) {
            if (friendPlayer == null) {
                throw new NullPointerException("friendPlayer is marked non-null but is null");
            }
            this.friendPlayer = friendPlayer;
            return this;
        }

        @Generated
        public PlayerFriendStatusBuilder addedAt(@NonNull Instant addedAt) {
            if (addedAt == null) {
                throw new NullPointerException("addedAt is marked non-null but is null");
            }
            this.addedAt = addedAt;
            return this;
        }

        @Generated
        public PlayerFriendStatusBuilder online(boolean online) {
            this.online = online;
            return this;
        }

        @Generated
        public PlayerFriendStatusBuilder lastOnlineAt(@NonNull Instant lastOnlineAt) {
            if (lastOnlineAt == null) {
                throw new NullPointerException("lastOnlineAt is marked non-null but is null");
            }
            this.lastOnlineAt = lastOnlineAt;
            return this;
        }

        @Generated
        public PlayerFriendStatusBuilder serverLocation(@Nullable ServerLocation serverLocation) {
            this.serverLocation = serverLocation;
            return this;
        }

        @Generated
        public PlayerFriendStatus build() {
            return new PlayerFriendStatus(this.player, this.friendPlayer, this.addedAt, this.online, this.lastOnlineAt, this.serverLocation);
        }

        @Generated
        public String toString() {
            return "PlayerFriendStatus.PlayerFriendStatusBuilder(player=" + String.valueOf(this.player) + ", friendPlayer=" + String.valueOf(this.friendPlayer) + ", addedAt=" + String.valueOf(this.addedAt) + ", online=" + this.online + ", lastOnlineAt=" + String.valueOf(this.lastOnlineAt) + ", serverLocation=" + String.valueOf(this.serverLocation) + ")";
        }
    }
}

