/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild;

import com.mineplex.studio.dataplane.common.guild.model.GuildRole;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public class GuildCommon {
    public static final String MEMBER_ADD_MESSAGE_CHANNEL = "guild-member-add";
    public static final String MEMBER_ROLE_UPDATE_MESSAGE_CHANNEL = "guild-member-role-update";
    public static final String MEMBER_KICK_MESSAGE_CHANNEL = "guild-member-kick";
    public static final String MEMBER_LEAVE_MESSAGE_CHANNEL = "guild-member-leave";
    public static final String INVITE_MESSAGE_CHANNEL = "guild-invite";
    public static final String INVITE_CANCEL_MESSAGE_CHANNEL = "guild-invite-cancel";
    public static final String INVITE_REJECT_MESSAGE_CHANNEL = "guild-invite-reject";
    public static final String CREATE_MESSAGE_CHANNEL = "guild-create";
    public static final String DELETE_MESSAGE_CHANNEL = "guild-delete";
    public static final String ACCESS_UPDATE_MESSAGE_CHANNEL = "guild-access-update";
    public static final String JOIN_REQUEST_MESSAGE_CHANNEL = "guild-join-request";
    public static final String JOIN_REQUEST_CANCEL_MESSAGE_CHANNEL = "guild-join-request-cancel";
    public static final String JOIN_REQUEST_REJECT_MESSAGE_CHANNEL = "guild-join-request-reject";
    public static final Pattern GUILD_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{3,16}$");
    public static final char GUILD_CHAT_PREFIX = '!';

    public static boolean isValidGuildName(String name) {
        return name != null && GUILD_NAME_PATTERN.matcher(name).matches();
    }

    public static GuildRole getDefaultRole() {
        return GuildRole.MEMBER;
    }

    @NonNull
    public static Optional<String> getParsedGuildMessage(@Nullable String message) {
        if (message == null || message.isEmpty()) {
            return Optional.empty();
        }
        if (message.charAt(0) != '!') {
            return Optional.empty();
        }
        return Optional.of(message.substring(1).trim());
    }

    @Generated
    private GuildCommon() {
    }
}

