/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild;

import com.mineplex.studio.dataplane.common.guild.GuildGrpcErrorMapper;
import com.mineplex.studio.dataplane.common.guild.GuildGrpcMapper;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyGuildMemberException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyGuildOwnerException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyInvitedToGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyRequestingToJoinException;
import com.mineplex.studio.dataplane.common.guild.exception.CantJoinRequestGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.DirectOwnerAssignmentException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildCreateException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildFullException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildNotFoundException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildOwnerModificationException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildPermissionException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildPermissionTargetException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildRoleLimitException;
import com.mineplex.studio.dataplane.common.guild.exception.NotGuildMemberException;
import com.mineplex.studio.dataplane.common.guild.exception.NotInvitedToGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.NotRequestingToJoinGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.OwnerLeaveGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.PlayerGuildLimitException;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermission;
import com.mineplex.studio.dataplane.common.guild.model.GuildRole;
import com.mineplex.studio.dataplane.common.guild.model.MinimalGuild;
import com.mineplex.studio.dataplane.common.profile.ProfileGrpcMapper;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import com.mineplex.studio.dataplane.contracts.GuildErrorAlreadyGuildMember;
import com.mineplex.studio.dataplane.contracts.GuildErrorAlreadyInvited;
import com.mineplex.studio.dataplane.contracts.GuildErrorAlreadyOwner;
import com.mineplex.studio.dataplane.contracts.GuildErrorAlreadyRequestedToJoin;
import com.mineplex.studio.dataplane.contracts.GuildErrorCannotJoinRequest;
import com.mineplex.studio.dataplane.contracts.GuildErrorDirectOwnerAssignment;
import com.mineplex.studio.dataplane.contracts.GuildErrorFailedToCreate;
import com.mineplex.studio.dataplane.contracts.GuildErrorFailedToCreateType;
import com.mineplex.studio.dataplane.contracts.GuildErrorFullGuild;
import com.mineplex.studio.dataplane.contracts.GuildErrorGuildNotFound;
import com.mineplex.studio.dataplane.contracts.GuildErrorLimitReached;
import com.mineplex.studio.dataplane.contracts.GuildErrorLimitType;
import com.mineplex.studio.dataplane.contracts.GuildErrorNotAMember;
import com.mineplex.studio.dataplane.contracts.GuildErrorNotInvited;
import com.mineplex.studio.dataplane.contracts.GuildErrorNotRequestedToJoin;
import com.mineplex.studio.dataplane.contracts.GuildErrorOwnerLeave;
import com.mineplex.studio.dataplane.contracts.GuildErrorOwnerModification;
import com.mineplex.studio.dataplane.contracts.GuildErrorPermissionDenied;
import com.mineplex.studio.dataplane.contracts.GuildErrorPermissionTargetDenied;
import com.mineplex.studio.dataplane.contracts.GuildErrorRoleLimit;

public class GuildGrpcErrorMapperImpl
implements GuildGrpcErrorMapper {
    private final GuildGrpcMapper guildGrpcMapper = GuildGrpcMapper.INSTANCE;
    private final ProfileGrpcMapper profileGrpcMapper = ProfileGrpcMapper.INSTANCE;

    @Override
    public AlreadyGuildMemberException grpcAlreadyGuildMemberToAlreadyGuildMemberException(GuildErrorAlreadyGuildMember grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        AlreadyGuildMemberException alreadyGuildMemberException = new AlreadyGuildMemberException(player, guild);
        return alreadyGuildMemberException;
    }

    @Override
    public GuildErrorAlreadyGuildMember alreadyGuildMemberExceptionToGrpcAlreadyGuildMember(AlreadyGuildMemberException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorAlreadyGuildMember.Builder guildErrorAlreadyGuildMember = GuildErrorAlreadyGuildMember.newBuilder();
        guildErrorAlreadyGuildMember.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorAlreadyGuildMember.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorAlreadyGuildMember.build();
    }

    @Override
    public AlreadyGuildOwnerException grpcAlreadyGuildOwnerToAlreadyGuildOwnerException(GuildErrorAlreadyOwner grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        AlreadyGuildOwnerException alreadyGuildOwnerException = new AlreadyGuildOwnerException(player, guild);
        return alreadyGuildOwnerException;
    }

    @Override
    public GuildErrorAlreadyOwner alreadyGuildOwnerExceptionToGrpcAlreadyGuildOwner(AlreadyGuildOwnerException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorAlreadyOwner.Builder guildErrorAlreadyOwner = GuildErrorAlreadyOwner.newBuilder();
        guildErrorAlreadyOwner.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorAlreadyOwner.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorAlreadyOwner.build();
    }

    @Override
    public AlreadyInvitedToGuildException grpcAlreadyInvitedToGuildToAlreadyInvitedToGuildException(GuildErrorAlreadyInvited grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        AlreadyInvitedToGuildException alreadyInvitedToGuildException = new AlreadyInvitedToGuildException(player, guild);
        return alreadyInvitedToGuildException;
    }

    @Override
    public GuildErrorAlreadyInvited alreadyInvitedToGuildExceptionToGrpcAlreadyInvitedToGuild(AlreadyInvitedToGuildException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorAlreadyInvited.Builder guildErrorAlreadyInvited = GuildErrorAlreadyInvited.newBuilder();
        guildErrorAlreadyInvited.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorAlreadyInvited.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorAlreadyInvited.build();
    }

    @Override
    public AlreadyRequestingToJoinException grpcAlreadyRequestingToJoinToAlreadyRequestingToJoinException(GuildErrorAlreadyRequestedToJoin grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        AlreadyRequestingToJoinException alreadyRequestingToJoinException = new AlreadyRequestingToJoinException(player, guild);
        return alreadyRequestingToJoinException;
    }

    @Override
    public GuildErrorAlreadyRequestedToJoin alreadyRequestingToJoinExceptionToGrpcAlreadyRequestingToJoin(AlreadyRequestingToJoinException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorAlreadyRequestedToJoin.Builder guildErrorAlreadyRequestedToJoin = GuildErrorAlreadyRequestedToJoin.newBuilder();
        guildErrorAlreadyRequestedToJoin.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorAlreadyRequestedToJoin.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorAlreadyRequestedToJoin.build();
    }

    @Override
    public CantJoinRequestGuildException grpcCantJoinRequestGuildToCantJoinRequestGuildException(GuildErrorCannotJoinRequest grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        CantJoinRequestGuildException cantJoinRequestGuildException = new CantJoinRequestGuildException(player, guild);
        return cantJoinRequestGuildException;
    }

    @Override
    public GuildErrorCannotJoinRequest cantJoinRequestGuildExceptionToGrpcCantJoinRequestGuild(CantJoinRequestGuildException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorCannotJoinRequest.Builder guildErrorCannotJoinRequest = GuildErrorCannotJoinRequest.newBuilder();
        guildErrorCannotJoinRequest.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorCannotJoinRequest.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorCannotJoinRequest.build();
    }

    @Override
    public DirectOwnerAssignmentException grpcDirectOwnerAssignmentToDirectOwnerAssignmentException(GuildErrorDirectOwnerAssignment grpcException) {
        if (grpcException == null) {
            return null;
        }
        MinimalGuild guild = null;
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        DirectOwnerAssignmentException directOwnerAssignmentException = new DirectOwnerAssignmentException(guild);
        return directOwnerAssignmentException;
    }

    @Override
    public GuildErrorDirectOwnerAssignment directOwnerAssignmentExceptionToGrpcDirectOwnerAssignment(DirectOwnerAssignmentException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorDirectOwnerAssignment.Builder guildErrorDirectOwnerAssignment = GuildErrorDirectOwnerAssignment.newBuilder();
        guildErrorDirectOwnerAssignment.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        return guildErrorDirectOwnerAssignment.build();
    }

    @Override
    public GuildFullException grpcGuildFullToGuildFullException(GuildErrorFullGuild grpcException) {
        if (grpcException == null) {
            return null;
        }
        MinimalGuild guild = null;
        int maxMembers = 0;
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        maxMembers = grpcException.getMaxMembers();
        GuildFullException guildFullException = new GuildFullException(guild, maxMembers);
        return guildFullException;
    }

    @Override
    public GuildErrorFullGuild guildFullExceptionToGrpcGuildFull(GuildFullException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorFullGuild.Builder guildErrorFullGuild = GuildErrorFullGuild.newBuilder();
        guildErrorFullGuild.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorFullGuild.setMaxMembers(exception.getMaxMembers());
        return guildErrorFullGuild.build();
    }

    @Override
    public GuildNotFoundException grpcGuildNotFoundToGuildNotFoundException(GuildErrorGuildNotFound grpcException) {
        if (grpcException == null) {
            return null;
        }
        String guildId = null;
        guildId = grpcException.getGuildId();
        GuildNotFoundException guildNotFoundException = new GuildNotFoundException(guildId);
        return guildNotFoundException;
    }

    @Override
    public GuildErrorGuildNotFound guildNotFoundExceptionToGrpcGuildNotFound(GuildNotFoundException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorGuildNotFound.Builder guildErrorGuildNotFound = GuildErrorGuildNotFound.newBuilder();
        guildErrorGuildNotFound.setGuildId(exception.getGuildId());
        return guildErrorGuildNotFound.build();
    }

    @Override
    public GuildOwnerModificationException grpcGuildOwnerModificationToGuildOwnerModificationException(GuildErrorOwnerModification grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        GuildOwnerModificationException guildOwnerModificationException = new GuildOwnerModificationException(player, guild);
        return guildOwnerModificationException;
    }

    @Override
    public GuildErrorOwnerModification guildOwnerModificationExceptionToGrpcGuildOwnerModification(GuildOwnerModificationException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorOwnerModification.Builder guildErrorOwnerModification = GuildErrorOwnerModification.newBuilder();
        guildErrorOwnerModification.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorOwnerModification.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorOwnerModification.build();
    }

    @Override
    public GuildPermissionException grpcGuildPermissionToGuildPermissionException(GuildErrorPermissionDenied grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        GuildPermission permission = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        permission = this.guildGrpcMapper.grpcGuildPermissionToGuildPermission(grpcException.getPermission());
        GuildPermissionException guildPermissionException = new GuildPermissionException(player, guild, permission);
        return guildPermissionException;
    }

    @Override
    public GuildErrorPermissionDenied guildPermissionExceptionToGrpcGuildPermission(GuildPermissionException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorPermissionDenied.Builder guildErrorPermissionDenied = GuildErrorPermissionDenied.newBuilder();
        guildErrorPermissionDenied.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorPermissionDenied.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        guildErrorPermissionDenied.setPermission(this.guildGrpcMapper.guildPermissionToGrpcGuildPermission(exception.getPermission()));
        return guildErrorPermissionDenied.build();
    }

    @Override
    public GuildPermissionTargetException grpcGuildPermissionTargetToGuildPermissionTargetException(GuildErrorPermissionTargetDenied grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        PlayerIdentity target = null;
        MinimalGuild guild = null;
        GuildPermission permission = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasTarget()) {
            target = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getTarget());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        permission = this.guildGrpcMapper.grpcGuildPermissionToGuildPermission(grpcException.getPermission());
        GuildPermissionTargetException guildPermissionTargetException = new GuildPermissionTargetException(player, target, guild, permission);
        return guildPermissionTargetException;
    }

    @Override
    public GuildErrorPermissionTargetDenied guildPermissionTargetExceptionToGrpcGuildPermissionTarget(GuildPermissionTargetException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorPermissionTargetDenied.Builder guildErrorPermissionTargetDenied = GuildErrorPermissionTargetDenied.newBuilder();
        guildErrorPermissionTargetDenied.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorPermissionTargetDenied.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        guildErrorPermissionTargetDenied.setTarget(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getTarget()));
        guildErrorPermissionTargetDenied.setPermission(this.guildGrpcMapper.guildPermissionToGrpcGuildPermission(exception.getPermission()));
        return guildErrorPermissionTargetDenied.build();
    }

    @Override
    public GuildRoleLimitException grpcGuildRoleLimitToGuildRoleLimitException(GuildErrorRoleLimit grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        GuildRole role = null;
        int maxMembers = 0;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        role = this.guildGrpcMapper.grpcGuildRoleToGuildRole(grpcException.getRole());
        maxMembers = grpcException.getMaxMembers();
        GuildRoleLimitException guildRoleLimitException = new GuildRoleLimitException(player, guild, role, maxMembers);
        return guildRoleLimitException;
    }

    @Override
    public GuildErrorRoleLimit guildRoleLimitExceptionToGrpcGuildRoleLimit(GuildRoleLimitException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorRoleLimit.Builder guildErrorRoleLimit = GuildErrorRoleLimit.newBuilder();
        guildErrorRoleLimit.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorRoleLimit.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        guildErrorRoleLimit.setRole(this.guildGrpcMapper.guildRoleToGrpcGuildRole(exception.getRole()));
        guildErrorRoleLimit.setMaxMembers(exception.getMaxMembers());
        return guildErrorRoleLimit.build();
    }

    @Override
    public GuildCreateException grpcGuildCreateExceptionToGuildCreateException(GuildErrorFailedToCreate grpcException) {
        if (grpcException == null) {
            return null;
        }
        String name = null;
        GuildCreateException.Reason reason = null;
        name = grpcException.getName();
        reason = this.guildErrorFailedToCreateTypeToReason(grpcException.getReason());
        GuildCreateException guildCreateException = new GuildCreateException(name, reason);
        return guildCreateException;
    }

    @Override
    public GuildErrorFailedToCreate guildCreateExceptionToGrpcGuildCreateException(GuildCreateException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorFailedToCreate.Builder guildErrorFailedToCreate = GuildErrorFailedToCreate.newBuilder();
        guildErrorFailedToCreate.setName(exception.getName());
        guildErrorFailedToCreate.setReason(this.reasonToGuildErrorFailedToCreateType(exception.getReason()));
        return guildErrorFailedToCreate.build();
    }

    @Override
    public NotGuildMemberException grpcNotGuildMemberToNotGuildMemberException(GuildErrorNotAMember grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        NotGuildMemberException notGuildMemberException = new NotGuildMemberException(player, guild);
        return notGuildMemberException;
    }

    @Override
    public GuildErrorNotAMember notGuildMemberExceptionToGrpcNotGuildMember(NotGuildMemberException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorNotAMember.Builder guildErrorNotAMember = GuildErrorNotAMember.newBuilder();
        guildErrorNotAMember.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorNotAMember.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorNotAMember.build();
    }

    @Override
    public NotInvitedToGuildException grpcNotInvitedToGuildToNotInvitedToGuildException(GuildErrorNotInvited grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        NotInvitedToGuildException notInvitedToGuildException = new NotInvitedToGuildException(player, guild);
        return notInvitedToGuildException;
    }

    @Override
    public GuildErrorNotInvited notInvitedToGuildExceptionToGrpcNotInvitedToGuild(NotInvitedToGuildException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorNotInvited.Builder guildErrorNotInvited = GuildErrorNotInvited.newBuilder();
        guildErrorNotInvited.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorNotInvited.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorNotInvited.build();
    }

    @Override
    public NotRequestingToJoinGuildException grpcNotRequestingToJoinGuildToNotRequestingToJoinGuildException(GuildErrorNotRequestedToJoin grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        NotRequestingToJoinGuildException notRequestingToJoinGuildException = new NotRequestingToJoinGuildException(player, guild);
        return notRequestingToJoinGuildException;
    }

    @Override
    public GuildErrorNotRequestedToJoin notRequestingToJoinGuildExceptionToGrpcNotRequestingToJoinGuild(NotRequestingToJoinGuildException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorNotRequestedToJoin.Builder guildErrorNotRequestedToJoin = GuildErrorNotRequestedToJoin.newBuilder();
        guildErrorNotRequestedToJoin.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorNotRequestedToJoin.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorNotRequestedToJoin.build();
    }

    @Override
    public OwnerLeaveGuildException grpcOwnerLeaveGuildToOwnerLeaveGuildException(GuildErrorOwnerLeave grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        MinimalGuild guild = null;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        if (grpcException.hasGuild()) {
            guild = this.guildGrpcMapper.grpcGuildToMinimalGuild(grpcException.getGuild());
        }
        OwnerLeaveGuildException ownerLeaveGuildException = new OwnerLeaveGuildException(player, guild);
        return ownerLeaveGuildException;
    }

    @Override
    public GuildErrorOwnerLeave ownerLeaveGuildExceptionToGrpcOwnerLeaveGuild(OwnerLeaveGuildException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorOwnerLeave.Builder guildErrorOwnerLeave = GuildErrorOwnerLeave.newBuilder();
        guildErrorOwnerLeave.setGuild(this.guildGrpcMapper.minimalGuildToGrpcMinimalGuild(exception.getGuild()));
        guildErrorOwnerLeave.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        return guildErrorOwnerLeave.build();
    }

    @Override
    public PlayerGuildLimitException grpcPlayerGuildLimitToPlayerGuildLimitException(GuildErrorLimitReached grpcException) {
        if (grpcException == null) {
            return null;
        }
        PlayerIdentity player = null;
        PlayerGuildLimitException.LimitType limitType = null;
        int limit = 0;
        if (grpcException.hasPlayer()) {
            player = this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcException.getPlayer());
        }
        limitType = this.guildErrorLimitTypeToLimitType(grpcException.getLimitType());
        limit = grpcException.getLimit();
        PlayerGuildLimitException playerGuildLimitException = new PlayerGuildLimitException(player, limitType, limit);
        return playerGuildLimitException;
    }

    @Override
    public GuildErrorLimitReached playerGuildLimitExceptionToGrpcPlayerGuildLimit(PlayerGuildLimitException exception) {
        if (exception == null) {
            return null;
        }
        GuildErrorLimitReached.Builder guildErrorLimitReached = GuildErrorLimitReached.newBuilder();
        guildErrorLimitReached.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(exception.getPlayer()));
        guildErrorLimitReached.setLimitType(this.limitTypeToGuildErrorLimitType(exception.getLimitType()));
        guildErrorLimitReached.setLimit(exception.getLimit());
        return guildErrorLimitReached.build();
    }

    protected GuildCreateException.Reason guildErrorFailedToCreateTypeToReason(GuildErrorFailedToCreateType guildErrorFailedToCreateType) {
        if (guildErrorFailedToCreateType == null) {
            return null;
        }
        return switch (guildErrorFailedToCreateType) {
            case GuildErrorFailedToCreateType.GUILD_ERROR_FAILED_TO_CREATE_TYPE_UNSPECIFIED -> null;
            case GuildErrorFailedToCreateType.ALREADY_EXISTS -> GuildCreateException.Reason.ALREADY_EXISTS;
            case GuildErrorFailedToCreateType.MALFORMED_NAME -> GuildCreateException.Reason.MALFORMED_NAME;
            case GuildErrorFailedToCreateType.UNRECOGNIZED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(guildErrorFailedToCreateType));
        };
    }

    protected GuildErrorFailedToCreateType reasonToGuildErrorFailedToCreateType(GuildCreateException.Reason reason) {
        if (reason == null) {
            return GuildErrorFailedToCreateType.GUILD_ERROR_FAILED_TO_CREATE_TYPE_UNSPECIFIED;
        }
        return switch (reason) {
            case GuildCreateException.Reason.MALFORMED_NAME -> GuildErrorFailedToCreateType.MALFORMED_NAME;
            case GuildCreateException.Reason.ALREADY_EXISTS -> GuildErrorFailedToCreateType.ALREADY_EXISTS;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)reason));
        };
    }

    protected PlayerGuildLimitException.LimitType guildErrorLimitTypeToLimitType(GuildErrorLimitType guildErrorLimitType) {
        if (guildErrorLimitType == null) {
            return null;
        }
        return switch (guildErrorLimitType) {
            case GuildErrorLimitType.GUILD_ERROR_LIMIT_TYPE_UNSPECIFIED -> null;
            case GuildErrorLimitType.OWNERSHIP -> PlayerGuildLimitException.LimitType.OWNERSHIP;
            case GuildErrorLimitType.MEMBERSHIP -> PlayerGuildLimitException.LimitType.MEMBERSHIP;
            case GuildErrorLimitType.TOTAL -> PlayerGuildLimitException.LimitType.TOTAL;
            case GuildErrorLimitType.UNRECOGNIZED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(guildErrorLimitType));
        };
    }

    protected GuildErrorLimitType limitTypeToGuildErrorLimitType(PlayerGuildLimitException.LimitType limitType) {
        if (limitType == null) {
            return GuildErrorLimitType.GUILD_ERROR_LIMIT_TYPE_UNSPECIFIED;
        }
        return switch (limitType) {
            case PlayerGuildLimitException.LimitType.OWNERSHIP -> GuildErrorLimitType.OWNERSHIP;
            case PlayerGuildLimitException.LimitType.MEMBERSHIP -> GuildErrorLimitType.MEMBERSHIP;
            case PlayerGuildLimitException.LimitType.TOTAL -> GuildErrorLimitType.TOTAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)limitType));
        };
    }
}

