/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild;

import com.mineplex.studio.dataplane.common.guild.GuildGrpcErrorMapper;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyGuildMemberException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyGuildOwnerException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyInvitedToGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyRequestingToJoinException;
import com.mineplex.studio.dataplane.common.guild.exception.CantJoinRequestGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.DirectOwnerAssignmentException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildCreateException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildFullException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildNotFoundException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildOwnerModificationException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildPermissionException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildPermissionTargetException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildRoleLimitException;
import com.mineplex.studio.dataplane.common.guild.exception.NotGuildMemberException;
import com.mineplex.studio.dataplane.common.guild.exception.NotInvitedToGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.NotRequestingToJoinGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.OwnerLeaveGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.PlayerGuildLimitException;
import com.mineplex.studio.dataplane.contracts.GuildErrorAlreadyGuildMember;
import com.mineplex.studio.dataplane.contracts.GuildErrorAlreadyInvited;
import com.mineplex.studio.dataplane.contracts.GuildErrorAlreadyOwner;
import com.mineplex.studio.dataplane.contracts.GuildErrorAlreadyRequestedToJoin;
import com.mineplex.studio.dataplane.contracts.GuildErrorCannotJoinRequest;
import com.mineplex.studio.dataplane.contracts.GuildErrorDirectOwnerAssignment;
import com.mineplex.studio.dataplane.contracts.GuildErrorFailedToCreate;
import com.mineplex.studio.dataplane.contracts.GuildErrorFullGuild;
import com.mineplex.studio.dataplane.contracts.GuildErrorGuildNotFound;
import com.mineplex.studio.dataplane.contracts.GuildErrorLimitReached;
import com.mineplex.studio.dataplane.contracts.GuildErrorNotAMember;
import com.mineplex.studio.dataplane.contracts.GuildErrorNotInvited;
import com.mineplex.studio.dataplane.contracts.GuildErrorNotRequestedToJoin;
import com.mineplex.studio.dataplane.contracts.GuildErrorOwnerLeave;
import com.mineplex.studio.dataplane.contracts.GuildErrorOwnerModification;
import com.mineplex.studio.dataplane.contracts.GuildErrorPermissionDenied;
import com.mineplex.studio.dataplane.contracts.GuildErrorPermissionTargetDenied;
import com.mineplex.studio.dataplane.contracts.GuildErrorRoleLimit;
import com.mineplex.studio.deps.com.google.protobuf.Any;
import com.mineplex.studio.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.mineplex.studio.deps.com.google.protobuf.Message;
import com.mineplex.studio.deps.io.grpc.Metadata;
import com.mineplex.studio.deps.io.grpc.Status;
import com.mineplex.studio.deps.io.grpc.StatusRuntimeException;
import com.mineplex.studio.deps.io.grpc.protobuf.StatusProto;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class GuildGrpcExceptionMapper {
    private static final Map<Class<? extends GuildException>, ExceptionMapping<? extends GuildException>> EXCEPTION_TO_GRPC_MAPPINGS = new HashMap<Class<? extends GuildException>, ExceptionMapping<? extends GuildException>>();
    private static final Map<Class<? extends Message>, GrpcToExceptionMapping<?, ?>> GRPC_TO_EXCEPTION_MAPPINGS = new HashMap();

    public static <E extends GuildException> StatusRuntimeException toStatusException(E exception) {
        ExceptionMapping<? extends GuildException> mapping = EXCEPTION_TO_GRPC_MAPPINGS.get(exception.getClass());
        if (mapping != null) {
            return mapping.toStatusException(exception);
        }
        return Status.UNKNOWN.withDescription(exception.getMessage()).withCause(exception).asRuntimeException();
    }

    public static Optional<GuildException> fromStatusException(StatusRuntimeException exception) {
        Metadata metadata = exception.getTrailers();
        if (metadata == null) {
            return Optional.empty();
        }
        com.mineplex.studio.deps.com.google.rpc.Status status = StatusProto.fromStatusAndTrailers(exception.getStatus(), metadata);
        if (status == null || status.getDetailsCount() == 0) {
            return Optional.empty();
        }
        Any details = status.getDetails(0);
        for (Map.Entry<Class<Message>, GrpcToExceptionMapping<?, ?>> entry : GRPC_TO_EXCEPTION_MAPPINGS.entrySet()) {
            try {
                if (!details.is(entry.getKey())) continue;
                return Optional.ofNullable(GuildGrpcExceptionMapper.convertMessageToException(details, entry.getKey(), entry.getValue()));
            }
            catch (InvalidProtocolBufferException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static <M extends Message, E extends GuildException> E convertMessageToException(Any details, Class<M> messageClass, GrpcToExceptionMapping<?, ?> converter) throws InvalidProtocolBufferException {
        M message = details.unpack(messageClass);
        GrpcToExceptionMapping<?, ?> typedConverter = converter;
        return (E)typedConverter.convert(message);
    }

    private static StatusRuntimeException createStatusException(Status status, String message, Message error) {
        com.mineplex.studio.deps.com.google.rpc.Status statusWithDetails = com.mineplex.studio.deps.com.google.rpc.Status.newBuilder().setCode(status.getCode().value()).setMessage(message).addDetails(Any.pack(error)).build();
        return StatusProto.toStatusRuntimeException(statusWithDetails);
    }

    private static <E extends GuildException, G extends Message> void registerExceptionMapping(Class<E> exceptionClass, Function<E, G> errorMapper, Status status, String message) {
        EXCEPTION_TO_GRPC_MAPPINGS.put(exceptionClass, exception -> {
            GuildException typedException = (GuildException)exceptionClass.cast(exception);
            Message error = (Message)errorMapper.apply(typedException);
            return GuildGrpcExceptionMapper.createStatusException(status, message, error);
        });
    }

    private static <M extends Message, E extends GuildException> void registerGrpcMapping(Class<M> grpcErrorClass, Function<M, E> exceptionMapper) {
        GRPC_TO_EXCEPTION_MAPPINGS.put(grpcErrorClass, exceptionMapper::apply);
    }

    static {
        GuildGrpcExceptionMapper.registerExceptionMapping(GuildNotFoundException.class, GuildGrpcErrorMapper.INSTANCE::guildNotFoundExceptionToGrpcGuildNotFound, Status.NOT_FOUND, "Guild not found");
        GuildGrpcExceptionMapper.registerExceptionMapping(AlreadyGuildMemberException.class, GuildGrpcErrorMapper.INSTANCE::alreadyGuildMemberExceptionToGrpcAlreadyGuildMember, Status.ALREADY_EXISTS, "Player is already a guild member");
        GuildGrpcExceptionMapper.registerExceptionMapping(AlreadyGuildOwnerException.class, GuildGrpcErrorMapper.INSTANCE::alreadyGuildOwnerExceptionToGrpcAlreadyGuildOwner, Status.ALREADY_EXISTS, "Player is already a guild owner");
        GuildGrpcExceptionMapper.registerExceptionMapping(AlreadyInvitedToGuildException.class, GuildGrpcErrorMapper.INSTANCE::alreadyInvitedToGuildExceptionToGrpcAlreadyInvitedToGuild, Status.ALREADY_EXISTS, "Player is already invited to the guild");
        GuildGrpcExceptionMapper.registerExceptionMapping(AlreadyRequestingToJoinException.class, GuildGrpcErrorMapper.INSTANCE::alreadyRequestingToJoinExceptionToGrpcAlreadyRequestingToJoin, Status.ALREADY_EXISTS, "Player has already requested to join");
        GuildGrpcExceptionMapper.registerExceptionMapping(CantJoinRequestGuildException.class, GuildGrpcErrorMapper.INSTANCE::cantJoinRequestGuildExceptionToGrpcCantJoinRequestGuild, Status.FAILED_PRECONDITION, "Cannot join guild request");
        GuildGrpcExceptionMapper.registerExceptionMapping(DirectOwnerAssignmentException.class, GuildGrpcErrorMapper.INSTANCE::directOwnerAssignmentExceptionToGrpcDirectOwnerAssignment, Status.FAILED_PRECONDITION, "Cannot directly assign owner role");
        GuildGrpcExceptionMapper.registerExceptionMapping(GuildFullException.class, GuildGrpcErrorMapper.INSTANCE::guildFullExceptionToGrpcGuildFull, Status.RESOURCE_EXHAUSTED, "Guild is full");
        GuildGrpcExceptionMapper.registerExceptionMapping(GuildOwnerModificationException.class, GuildGrpcErrorMapper.INSTANCE::guildOwnerModificationExceptionToGrpcGuildOwnerModification, Status.FAILED_PRECONDITION, "Cannot modify guild owner");
        GuildGrpcExceptionMapper.registerExceptionMapping(GuildPermissionException.class, GuildGrpcErrorMapper.INSTANCE::guildPermissionExceptionToGrpcGuildPermission, Status.PERMISSION_DENIED, "Guild permission denied");
        GuildGrpcExceptionMapper.registerExceptionMapping(GuildPermissionTargetException.class, GuildGrpcErrorMapper.INSTANCE::guildPermissionTargetExceptionToGrpcGuildPermissionTarget, Status.PERMISSION_DENIED, "Guild permission denied for target");
        GuildGrpcExceptionMapper.registerExceptionMapping(GuildRoleLimitException.class, GuildGrpcErrorMapper.INSTANCE::guildRoleLimitExceptionToGrpcGuildRoleLimit, Status.RESOURCE_EXHAUSTED, "Guild role limit reached");
        GuildGrpcExceptionMapper.registerExceptionMapping(GuildCreateException.class, GuildGrpcErrorMapper.INSTANCE::guildCreateExceptionToGrpcGuildCreateException, Status.INVALID_ARGUMENT, "Failed to create guild");
        GuildGrpcExceptionMapper.registerExceptionMapping(NotGuildMemberException.class, GuildGrpcErrorMapper.INSTANCE::notGuildMemberExceptionToGrpcNotGuildMember, Status.FAILED_PRECONDITION, "Player is not a guild member");
        GuildGrpcExceptionMapper.registerExceptionMapping(NotInvitedToGuildException.class, GuildGrpcErrorMapper.INSTANCE::notInvitedToGuildExceptionToGrpcNotInvitedToGuild, Status.FAILED_PRECONDITION, "Player is not invited to the guild");
        GuildGrpcExceptionMapper.registerExceptionMapping(OwnerLeaveGuildException.class, GuildGrpcErrorMapper.INSTANCE::ownerLeaveGuildExceptionToGrpcOwnerLeaveGuild, Status.FAILED_PRECONDITION, "Guild owner cannot leave");
        GuildGrpcExceptionMapper.registerExceptionMapping(PlayerGuildLimitException.class, GuildGrpcErrorMapper.INSTANCE::playerGuildLimitExceptionToGrpcPlayerGuildLimit, Status.RESOURCE_EXHAUSTED, "Player guild limit reached");
        GuildGrpcExceptionMapper.registerExceptionMapping(NotRequestingToJoinGuildException.class, GuildGrpcErrorMapper.INSTANCE::notRequestingToJoinGuildExceptionToGrpcNotRequestingToJoinGuild, Status.FAILED_PRECONDITION, "Player is not requesting to join the guild");
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorGuildNotFound.class, GuildGrpcErrorMapper.INSTANCE::grpcGuildNotFoundToGuildNotFoundException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorAlreadyGuildMember.class, GuildGrpcErrorMapper.INSTANCE::grpcAlreadyGuildMemberToAlreadyGuildMemberException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorAlreadyOwner.class, GuildGrpcErrorMapper.INSTANCE::grpcAlreadyGuildOwnerToAlreadyGuildOwnerException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorAlreadyInvited.class, GuildGrpcErrorMapper.INSTANCE::grpcAlreadyInvitedToGuildToAlreadyInvitedToGuildException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorAlreadyRequestedToJoin.class, GuildGrpcErrorMapper.INSTANCE::grpcAlreadyRequestingToJoinToAlreadyRequestingToJoinException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorCannotJoinRequest.class, GuildGrpcErrorMapper.INSTANCE::grpcCantJoinRequestGuildToCantJoinRequestGuildException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorDirectOwnerAssignment.class, GuildGrpcErrorMapper.INSTANCE::grpcDirectOwnerAssignmentToDirectOwnerAssignmentException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorFullGuild.class, GuildGrpcErrorMapper.INSTANCE::grpcGuildFullToGuildFullException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorOwnerModification.class, GuildGrpcErrorMapper.INSTANCE::grpcGuildOwnerModificationToGuildOwnerModificationException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorPermissionDenied.class, GuildGrpcErrorMapper.INSTANCE::grpcGuildPermissionToGuildPermissionException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorPermissionTargetDenied.class, GuildGrpcErrorMapper.INSTANCE::grpcGuildPermissionTargetToGuildPermissionTargetException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorRoleLimit.class, GuildGrpcErrorMapper.INSTANCE::grpcGuildRoleLimitToGuildRoleLimitException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorFailedToCreate.class, GuildGrpcErrorMapper.INSTANCE::grpcGuildCreateExceptionToGuildCreateException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorNotAMember.class, GuildGrpcErrorMapper.INSTANCE::grpcNotGuildMemberToNotGuildMemberException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorNotInvited.class, GuildGrpcErrorMapper.INSTANCE::grpcNotInvitedToGuildToNotInvitedToGuildException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorOwnerLeave.class, GuildGrpcErrorMapper.INSTANCE::grpcOwnerLeaveGuildToOwnerLeaveGuildException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorLimitReached.class, GuildGrpcErrorMapper.INSTANCE::grpcPlayerGuildLimitToPlayerGuildLimitException);
        GuildGrpcExceptionMapper.registerGrpcMapping(GuildErrorNotRequestedToJoin.class, GuildGrpcErrorMapper.INSTANCE::grpcNotRequestingToJoinGuildToNotRequestingToJoinGuildException);
    }

    private static interface ExceptionMapping<E extends GuildException> {
        public StatusRuntimeException toStatusException(E var1);
    }

    private static interface GrpcToExceptionMapping<M extends Message, E extends GuildException> {
        public E convert(M var1) throws InvalidProtocolBufferException;
    }
}

