/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild;

import com.mineplex.studio.dataplane.common.CommonGrpcMapper;
import com.mineplex.studio.dataplane.common.CommonMapper;
import com.mineplex.studio.dataplane.common.guild.model.Guild;
import com.mineplex.studio.dataplane.common.guild.model.GuildAccess;
import com.mineplex.studio.dataplane.common.guild.model.GuildInvitedPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildJoinRequestedPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildMemberProperties;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermission;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermissionContext;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermissionTargetingMode;
import com.mineplex.studio.dataplane.common.guild.model.GuildPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildRole;
import com.mineplex.studio.dataplane.common.guild.model.MinimalGuild;
import com.mineplex.studio.dataplane.common.guild.model.PlayerGuildInformation;
import com.mineplex.studio.dataplane.common.profile.ProfileGrpcMapper;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.CollectionMappingStrategy;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.Mapper;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.Mapping;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.Mappings;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.Named;
import com.mineplex.studio.dataplane.common.shaded.org.mapstruct.factory.Mappers;
import com.mineplex.studio.dataplane.contracts.GuildMemberLimitByRole;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, uses={CommonGrpcMapper.class, CommonMapper.class, ProfileGrpcMapper.class})
public interface GuildGrpcMapper {
    public static final GuildGrpcMapper INSTANCE = Mappers.getMapper(GuildGrpcMapper.class);

    @Mappings(value={@Mapping(target="invitedPlayers", source="invitedPlayers"), @Mapping(target="rolePermissions", source="allPermissionContexts"), @Mapping(target="joinRequestedPlayers", source="joinRequestedPlayers")})
    public com.mineplex.studio.dataplane.contracts.Guild guildToGrpcGuild(Guild var1);

    @Mappings(value={@Mapping(target="invitedMap", source="invitedPlayers"), @Mapping(target="rolePermissions", source="rolePermissions", qualifiedByName={"grpcGuildPermissionsContextListToGuildPermissionsContextMap"}), @Mapping(target="joinRequested", source="joinRequestedPlayers"), @Mapping(target="membersMap", source="members")})
    public Guild grpcGuildToGuild(com.mineplex.studio.dataplane.contracts.Guild var1);

    public GuildInvitedPlayer grpcGuildInvitedToGuildInvited(com.mineplex.studio.dataplane.contracts.GuildInvitedPlayer var1);

    public com.mineplex.studio.dataplane.contracts.GuildInvitedPlayer guildInvitedToGrpcGuildInvited(GuildInvitedPlayer var1);

    public GuildJoinRequestedPlayer grpcGuildJoinRequestedToGuildJoinRequested(com.mineplex.studio.dataplane.contracts.GuildJoinRequestedPlayer var1);

    public com.mineplex.studio.dataplane.contracts.GuildJoinRequestedPlayer guildJoinRequestedToGrpcGuildJoinRequested(GuildJoinRequestedPlayer var1);

    public GuildPermission grpcGuildPermissionToGuildPermission(com.mineplex.studio.dataplane.contracts.GuildPermission var1);

    public com.mineplex.studio.dataplane.contracts.GuildPermission guildPermissionToGrpcGuildPermission(GuildPermission var1);

    public GuildPermissionTargetingMode grpcGuildPermissionTargetingModeToGuildPermissionTargetingMode(com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode var1);

    public com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode guildPermissionTargetingModeToGrpcGuildPermissionTargetingMode(GuildPermissionTargetingMode var1);

    public GuildPermissionContext grpcGuildPermissionContextToGuildPermissionContext(com.mineplex.studio.dataplane.contracts.GuildPermissionContext var1);

    public com.mineplex.studio.dataplane.contracts.GuildPermissionContext guildPermissionContextToGrpcGuildPermissionContext(GuildPermissionContext var1);

    default public Map<UUID, GuildInvitedPlayer> grpcGuildInvitedToGuildInvited(List<com.mineplex.studio.dataplane.contracts.GuildInvitedPlayer> grpcInvited) {
        HashMap<UUID, GuildInvitedPlayer> invited = new HashMap<UUID, GuildInvitedPlayer>(grpcInvited.size());
        for (com.mineplex.studio.dataplane.contracts.GuildInvitedPlayer grpcIdentity : grpcInvited) {
            GuildInvitedPlayer identity = this.grpcGuildInvitedToGuildInvited(grpcIdentity);
            invited.put(identity.getIdentity().getId(), identity);
        }
        return invited;
    }

    default public Map<UUID, GuildJoinRequestedPlayer> grpcGuildJoinRequestToGuildJoinRequested(List<com.mineplex.studio.dataplane.contracts.GuildJoinRequestedPlayer> grpcInvited) {
        HashMap<UUID, GuildJoinRequestedPlayer> invited = new HashMap<UUID, GuildJoinRequestedPlayer>(grpcInvited.size());
        for (com.mineplex.studio.dataplane.contracts.GuildJoinRequestedPlayer grpcIdentity : grpcInvited) {
            GuildJoinRequestedPlayer identity = this.grpcGuildJoinRequestedToGuildJoinRequested(grpcIdentity);
            invited.put(identity.getIdentity().getId(), identity);
        }
        return invited;
    }

    default public Map<UUID, GuildPlayer> grpcGuildMembersToGuildMembers(List<com.mineplex.studio.dataplane.contracts.GuildPlayer> grpcMembers) {
        HashMap<UUID, GuildPlayer> members = new HashMap<UUID, GuildPlayer>(grpcMembers.size());
        for (com.mineplex.studio.dataplane.contracts.GuildPlayer grpcMember : grpcMembers) {
            GuildPlayer guildPlayer = this.grpcGuildPlayerToGuildPlayer(grpcMember);
            members.put(guildPlayer.getPlayer().getId(), guildPlayer);
        }
        return members;
    }

    @Named(value="grpcGuildPermissionsContextListToGuildPermissionsContextMap")
    default public Map<GuildRole, @NonNull Map<@NonNull GuildPermission, GuildPermissionContext>> grpcGuildPermissionsContextListToGuildPermissionsContextMap(List<com.mineplex.studio.dataplane.contracts.GuildPermissionContext> grpcPermissionContexts) {
        EnumMap<GuildRole, @NonNull Map<@NonNull GuildPermission, GuildPermissionContext>> rolePermissions = new EnumMap<GuildRole, Map<GuildPermission, GuildPermissionContext>>(GuildRole.class);
        for (com.mineplex.studio.dataplane.contracts.GuildPermissionContext grpcContext : grpcPermissionContexts) {
            GuildRole role = this.grpcGuildRoleToGuildRole(grpcContext.getRole());
            GuildPermission permission = this.grpcGuildPermissionToGuildPermission(grpcContext.getPermission());
            GuildPermissionContext context = this.grpcGuildPermissionContextToGuildPermissionContext(grpcContext);
            rolePermissions.computeIfAbsent(role, k -> new EnumMap(GuildPermission.class)).put(permission, context);
        }
        return rolePermissions;
    }

    public GuildPlayer grpcGuildPlayerToGuildPlayer(com.mineplex.studio.dataplane.contracts.GuildPlayer var1);

    public com.mineplex.studio.dataplane.contracts.GuildPlayer guildPlayerToGrpcGuildPlayer(GuildPlayer var1);

    public GuildAccess grpcGuildAccessToGuildAccess(com.mineplex.studio.dataplane.contracts.GuildAccess var1);

    public com.mineplex.studio.dataplane.contracts.GuildAccess guildAccessToGrpcGuildAccess(GuildAccess var1);

    public GuildRole grpcGuildRoleToGuildRole(com.mineplex.studio.dataplane.contracts.GuildRole var1);

    public com.mineplex.studio.dataplane.contracts.GuildRole guildRoleToGrpcGuildRole(GuildRole var1);

    public PlayerGuildInformation grpcPlayerGuildInformationToPlayerGuildInformation(com.mineplex.studio.dataplane.contracts.PlayerGuildInformation var1);

    public com.mineplex.studio.dataplane.contracts.PlayerGuildInformation playerGuildInformationToGrpcPlayerGuildInformation(PlayerGuildInformation var1);

    public GuildMemberProperties grpcGuildPropertiesToGuildProperties(com.mineplex.studio.dataplane.contracts.GuildMemberProperties var1);

    public com.mineplex.studio.dataplane.contracts.GuildMemberProperties guildPropertiesToGrpcGuildProperties(GuildMemberProperties var1);

    public GuildMemberLimitByRole guildPropertiesMemberLimitToGrpcGuildMemberLimitByRole(GuildMemberProperties.GuildMemberLimitByRole var1);

    public GuildMemberProperties.GuildMemberLimitByRole grpcGuildMemberLimitByRoleToGuildPropertiesMemberLimit(GuildMemberLimitByRole var1);

    public MinimalGuild grpcGuildToMinimalGuild(com.mineplex.studio.dataplane.contracts.MinimalGuild var1);

    public com.mineplex.studio.dataplane.contracts.MinimalGuild minimalGuildToGrpcMinimalGuild(MinimalGuild var1);
}

