/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild;

import com.mineplex.studio.dataplane.common.guild.GuildGrpcMapper;
import com.mineplex.studio.dataplane.common.guild.model.Guild;
import com.mineplex.studio.dataplane.common.guild.model.GuildAccess;
import com.mineplex.studio.dataplane.common.guild.model.GuildInvitedPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildJoinRequestedPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildMemberProperties;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermission;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermissionContext;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermissionTargetingMode;
import com.mineplex.studio.dataplane.common.guild.model.GuildPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildRole;
import com.mineplex.studio.dataplane.common.guild.model.MinimalGuild;
import com.mineplex.studio.dataplane.common.guild.model.PlayerGuildInformation;
import com.mineplex.studio.dataplane.common.profile.ProfileGrpcMapper;
import com.mineplex.studio.dataplane.contracts.Guild;
import com.mineplex.studio.dataplane.contracts.GuildInvitedPlayer;
import com.mineplex.studio.dataplane.contracts.GuildJoinRequestedPlayer;
import com.mineplex.studio.dataplane.contracts.GuildMemberLimitByRole;
import com.mineplex.studio.dataplane.contracts.GuildMemberProperties;
import com.mineplex.studio.dataplane.contracts.GuildPermissionContext;
import com.mineplex.studio.dataplane.contracts.GuildPlayer;
import com.mineplex.studio.dataplane.contracts.MinimalGuild;
import com.mineplex.studio.dataplane.contracts.PlayerGuildInformation;
import com.mineplex.studio.deps.com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class GuildGrpcMapperImpl
implements GuildGrpcMapper {
    private final ProfileGrpcMapper profileGrpcMapper = ProfileGrpcMapper.INSTANCE;

    @Override
    public com.mineplex.studio.dataplane.contracts.Guild guildToGrpcGuild(Guild guild) {
        if (guild == null) {
            return null;
        }
        Guild.Builder guild1 = com.mineplex.studio.dataplane.contracts.Guild.newBuilder();
        if (guild.getInvitedPlayers() != null) {
            for (GuildInvitedPlayer invitedPlayer : guild.getInvitedPlayers()) {
                guild1.addInvitedPlayers(this.guildInvitedToGrpcGuildInvited(invitedPlayer));
            }
        }
        if (guild.getAllPermissionContexts() != null) {
            for (GuildPermissionContext allPermissionContext : guild.getAllPermissionContexts()) {
                guild1.addRolePermissions(this.guildPermissionContextToGrpcGuildPermissionContext(allPermissionContext));
            }
        }
        if (guild.getJoinRequestedPlayers() != null) {
            for (GuildJoinRequestedPlayer joinRequestedPlayer : guild.getJoinRequestedPlayers()) {
                guild1.addJoinRequestedPlayers(this.guildJoinRequestedToGrpcGuildJoinRequested(joinRequestedPlayer));
            }
        }
        guild1.setId(guild.getId());
        guild1.setName(guild.getName());
        guild1.setAccess(this.guildAccessToGrpcGuildAccess(guild.getAccess()));
        guild1.setLevel(guild.getLevel());
        guild1.setTotalExperience(guild.getTotalExperience());
        guild1.setMemberProperties(this.guildPropertiesToGrpcGuildProperties(guild.getMemberProperties()));
        if (guild.getMembers() != null) {
            for (GuildPlayer member : guild.getMembers()) {
                guild1.addMembers(this.guildPlayerToGrpcGuildPlayer(member));
            }
        }
        return guild1.build();
    }

    @Override
    public Guild grpcGuildToGuild(com.mineplex.studio.dataplane.contracts.Guild grpcGuild) {
        if (grpcGuild == null) {
            return null;
        }
        Guild.GuildBuilder guild = Guild.builder();
        guild.invitedMap(this.grpcGuildInvitedToGuildInvited(grpcGuild.getInvitedPlayersList()));
        guild.rolePermissions(this.grpcGuildPermissionsContextListToGuildPermissionsContextMap(grpcGuild.getRolePermissionsList()));
        guild.joinRequested(this.grpcGuildJoinRequestToGuildJoinRequested(grpcGuild.getJoinRequestedPlayersList()));
        guild.membersMap(this.grpcGuildMembersToGuildMembers(grpcGuild.getMembersList()));
        guild.id(grpcGuild.getId());
        guild.name(grpcGuild.getName());
        guild.access(this.grpcGuildAccessToGuildAccess(grpcGuild.getAccess()));
        if (grpcGuild.hasMemberProperties()) {
            guild.memberProperties(this.grpcGuildPropertiesToGuildProperties(grpcGuild.getMemberProperties()));
        }
        guild.totalExperience(grpcGuild.getTotalExperience());
        guild.level(grpcGuild.getLevel());
        return guild.build();
    }

    @Override
    public GuildInvitedPlayer grpcGuildInvitedToGuildInvited(com.mineplex.studio.dataplane.contracts.GuildInvitedPlayer grpcGuildInvitedPlayer) {
        if (grpcGuildInvitedPlayer == null) {
            return null;
        }
        GuildInvitedPlayer.GuildInvitedPlayerBuilder guildInvitedPlayer = GuildInvitedPlayer.builder();
        if (grpcGuildInvitedPlayer.hasIdentity()) {
            guildInvitedPlayer.identity(this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcGuildInvitedPlayer.getIdentity()));
        }
        return guildInvitedPlayer.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildInvitedPlayer guildInvitedToGrpcGuildInvited(GuildInvitedPlayer guildInvitedPlayer) {
        if (guildInvitedPlayer == null) {
            return null;
        }
        GuildInvitedPlayer.Builder guildInvitedPlayer1 = com.mineplex.studio.dataplane.contracts.GuildInvitedPlayer.newBuilder();
        guildInvitedPlayer1.setIdentity(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(guildInvitedPlayer.getIdentity()));
        return guildInvitedPlayer1.build();
    }

    @Override
    public GuildJoinRequestedPlayer grpcGuildJoinRequestedToGuildJoinRequested(com.mineplex.studio.dataplane.contracts.GuildJoinRequestedPlayer grpcGuildJoinRequestedPlayer) {
        if (grpcGuildJoinRequestedPlayer == null) {
            return null;
        }
        GuildJoinRequestedPlayer.GuildJoinRequestedPlayerBuilder guildJoinRequestedPlayer = GuildJoinRequestedPlayer.builder();
        if (grpcGuildJoinRequestedPlayer.hasIdentity()) {
            guildJoinRequestedPlayer.identity(this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcGuildJoinRequestedPlayer.getIdentity()));
        }
        return guildJoinRequestedPlayer.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildJoinRequestedPlayer guildJoinRequestedToGrpcGuildJoinRequested(GuildJoinRequestedPlayer guildJoinRequestedPlayer) {
        if (guildJoinRequestedPlayer == null) {
            return null;
        }
        GuildJoinRequestedPlayer.Builder guildJoinRequestedPlayer1 = com.mineplex.studio.dataplane.contracts.GuildJoinRequestedPlayer.newBuilder();
        guildJoinRequestedPlayer1.setIdentity(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(guildJoinRequestedPlayer.getIdentity()));
        return guildJoinRequestedPlayer1.build();
    }

    @Override
    public GuildPermission grpcGuildPermissionToGuildPermission(com.mineplex.studio.dataplane.contracts.GuildPermission grpcGuildPermission) {
        if (grpcGuildPermission == null) {
            return null;
        }
        return switch (grpcGuildPermission) {
            case com.mineplex.studio.dataplane.contracts.GuildPermission.GUILD_PERMISSION_UNSPECIFIED -> null;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.INVITE_MEMBERS -> GuildPermission.INVITE_MEMBERS;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.REMOVE_MEMBERS -> GuildPermission.REMOVE_MEMBERS;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.ACCEPT_JOIN_REQUESTS -> GuildPermission.ACCEPT_JOIN_REQUESTS;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.DENY_JOIN_REQUESTS -> GuildPermission.DENY_JOIN_REQUESTS;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.BAN_MEMBERS -> GuildPermission.BAN_MEMBERS;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.CHANGE_ROLLS -> GuildPermission.CHANGE_ROLLS;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.TRANSFER_OWNERSHIP -> GuildPermission.TRANSFER_OWNERSHIP;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.DISBAND_GUILD -> GuildPermission.DISBAND_GUILD;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.CHANGE_ACCESS -> GuildPermission.CHANGE_ACCESS;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.UNINVITE_MEMBERS -> GuildPermission.UNINVITE_MEMBERS;
            case com.mineplex.studio.dataplane.contracts.GuildPermission.UNRECOGNIZED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(grpcGuildPermission));
        };
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildPermission guildPermissionToGrpcGuildPermission(GuildPermission guildPermission) {
        if (guildPermission == null) {
            return com.mineplex.studio.dataplane.contracts.GuildPermission.GUILD_PERMISSION_UNSPECIFIED;
        }
        return switch (guildPermission) {
            case GuildPermission.INVITE_MEMBERS -> com.mineplex.studio.dataplane.contracts.GuildPermission.INVITE_MEMBERS;
            case GuildPermission.UNINVITE_MEMBERS -> com.mineplex.studio.dataplane.contracts.GuildPermission.UNINVITE_MEMBERS;
            case GuildPermission.REMOVE_MEMBERS -> com.mineplex.studio.dataplane.contracts.GuildPermission.REMOVE_MEMBERS;
            case GuildPermission.ACCEPT_JOIN_REQUESTS -> com.mineplex.studio.dataplane.contracts.GuildPermission.ACCEPT_JOIN_REQUESTS;
            case GuildPermission.DENY_JOIN_REQUESTS -> com.mineplex.studio.dataplane.contracts.GuildPermission.DENY_JOIN_REQUESTS;
            case GuildPermission.BAN_MEMBERS -> com.mineplex.studio.dataplane.contracts.GuildPermission.BAN_MEMBERS;
            case GuildPermission.CHANGE_ACCESS -> com.mineplex.studio.dataplane.contracts.GuildPermission.CHANGE_ACCESS;
            case GuildPermission.CHANGE_ROLLS -> com.mineplex.studio.dataplane.contracts.GuildPermission.CHANGE_ROLLS;
            case GuildPermission.TRANSFER_OWNERSHIP -> com.mineplex.studio.dataplane.contracts.GuildPermission.TRANSFER_OWNERSHIP;
            case GuildPermission.DISBAND_GUILD -> com.mineplex.studio.dataplane.contracts.GuildPermission.DISBAND_GUILD;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)guildPermission));
        };
    }

    @Override
    public GuildPermissionTargetingMode grpcGuildPermissionTargetingModeToGuildPermissionTargetingMode(com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode grpcGuildPermissionTargetingMode) {
        if (grpcGuildPermissionTargetingMode == null) {
            return null;
        }
        return switch (grpcGuildPermissionTargetingMode) {
            case com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.GUILD_PERMISSION_TARGETING_MODE_UNSPECIFIED -> null;
            case com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.ANY -> GuildPermissionTargetingMode.ANY;
            case com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.LOWER -> GuildPermissionTargetingMode.LOWER;
            case com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.SAME_OR_LOWER -> GuildPermissionTargetingMode.SAME_OR_LOWER;
            case com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.ONLY_SAME -> GuildPermissionTargetingMode.ONLY_SAME;
            case com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.SELF -> GuildPermissionTargetingMode.SELF;
            case com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.UNRECOGNIZED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(grpcGuildPermissionTargetingMode));
        };
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode guildPermissionTargetingModeToGrpcGuildPermissionTargetingMode(GuildPermissionTargetingMode guildPermissionTargetingMode) {
        if (guildPermissionTargetingMode == null) {
            return com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.GUILD_PERMISSION_TARGETING_MODE_UNSPECIFIED;
        }
        return switch (guildPermissionTargetingMode) {
            case GuildPermissionTargetingMode.ANY -> com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.ANY;
            case GuildPermissionTargetingMode.LOWER -> com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.LOWER;
            case GuildPermissionTargetingMode.SAME_OR_LOWER -> com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.SAME_OR_LOWER;
            case GuildPermissionTargetingMode.ONLY_SAME -> com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.ONLY_SAME;
            case GuildPermissionTargetingMode.SELF -> com.mineplex.studio.dataplane.contracts.GuildPermissionTargetingMode.SELF;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)guildPermissionTargetingMode));
        };
    }

    @Override
    public GuildPermissionContext grpcGuildPermissionContextToGuildPermissionContext(com.mineplex.studio.dataplane.contracts.GuildPermissionContext grpcGuildPermissionContext) {
        if (grpcGuildPermissionContext == null) {
            return null;
        }
        GuildPermissionContext.GuildPermissionContextBuilder guildPermissionContext = GuildPermissionContext.builder();
        guildPermissionContext.role(this.grpcGuildRoleToGuildRole(grpcGuildPermissionContext.getRole()));
        guildPermissionContext.permission(this.grpcGuildPermissionToGuildPermission(grpcGuildPermissionContext.getPermission()));
        guildPermissionContext.target(this.grpcGuildPermissionTargetingModeToGuildPermissionTargetingMode(grpcGuildPermissionContext.getTarget()));
        return guildPermissionContext.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildPermissionContext guildPermissionContextToGrpcGuildPermissionContext(GuildPermissionContext guildPermissionContext) {
        if (guildPermissionContext == null) {
            return null;
        }
        GuildPermissionContext.Builder guildPermissionContext1 = com.mineplex.studio.dataplane.contracts.GuildPermissionContext.newBuilder();
        guildPermissionContext1.setRole(this.guildRoleToGrpcGuildRole(guildPermissionContext.getRole()));
        guildPermissionContext1.setPermission(this.guildPermissionToGrpcGuildPermission(guildPermissionContext.getPermission()));
        guildPermissionContext1.setTarget(this.guildPermissionTargetingModeToGrpcGuildPermissionTargetingMode(guildPermissionContext.getTarget()));
        return guildPermissionContext1.build();
    }

    @Override
    public GuildPlayer grpcGuildPlayerToGuildPlayer(com.mineplex.studio.dataplane.contracts.GuildPlayer grpcGuildPlayer) {
        if (grpcGuildPlayer == null) {
            return null;
        }
        GuildPlayer.GuildPlayerBuilder guildPlayer = GuildPlayer.builder();
        if (grpcGuildPlayer.hasPlayer()) {
            guildPlayer.player(this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcGuildPlayer.getPlayer()));
        }
        guildPlayer.role(this.grpcGuildRoleToGuildRole(grpcGuildPlayer.getRole()));
        return guildPlayer.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildPlayer guildPlayerToGrpcGuildPlayer(GuildPlayer guildPlayer) {
        if (guildPlayer == null) {
            return null;
        }
        GuildPlayer.Builder guildPlayer1 = com.mineplex.studio.dataplane.contracts.GuildPlayer.newBuilder();
        guildPlayer1.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(guildPlayer.getPlayer()));
        guildPlayer1.setRole(this.guildRoleToGrpcGuildRole(guildPlayer.getRole()));
        return guildPlayer1.build();
    }

    @Override
    public GuildAccess grpcGuildAccessToGuildAccess(com.mineplex.studio.dataplane.contracts.GuildAccess access) {
        if (access == null) {
            return null;
        }
        return switch (access) {
            case com.mineplex.studio.dataplane.contracts.GuildAccess.PUBLIC -> GuildAccess.PUBLIC;
            case com.mineplex.studio.dataplane.contracts.GuildAccess.PRIVATE -> GuildAccess.PRIVATE;
            case com.mineplex.studio.dataplane.contracts.GuildAccess.GUILD_ACCESS_UNSPECIFIED -> null;
            case com.mineplex.studio.dataplane.contracts.GuildAccess.UNRECOGNIZED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(access));
        };
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildAccess guildAccessToGrpcGuildAccess(GuildAccess access) {
        if (access == null) {
            return com.mineplex.studio.dataplane.contracts.GuildAccess.GUILD_ACCESS_UNSPECIFIED;
        }
        return switch (access) {
            case GuildAccess.PUBLIC -> com.mineplex.studio.dataplane.contracts.GuildAccess.PUBLIC;
            case GuildAccess.PRIVATE -> com.mineplex.studio.dataplane.contracts.GuildAccess.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)access));
        };
    }

    @Override
    public GuildRole grpcGuildRoleToGuildRole(com.mineplex.studio.dataplane.contracts.GuildRole grpcGuildRole) {
        if (grpcGuildRole == null) {
            return null;
        }
        return switch (grpcGuildRole) {
            case com.mineplex.studio.dataplane.contracts.GuildRole.OWNER -> GuildRole.OWNER;
            case com.mineplex.studio.dataplane.contracts.GuildRole.OFFICER -> GuildRole.OFFICER;
            case com.mineplex.studio.dataplane.contracts.GuildRole.MEMBER -> GuildRole.MEMBER;
            case com.mineplex.studio.dataplane.contracts.GuildRole.GUILD_ROLE_UNSPECIFIED -> null;
            case com.mineplex.studio.dataplane.contracts.GuildRole.UNRECOGNIZED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(grpcGuildRole));
        };
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildRole guildRoleToGrpcGuildRole(GuildRole guildRole) {
        if (guildRole == null) {
            return com.mineplex.studio.dataplane.contracts.GuildRole.GUILD_ROLE_UNSPECIFIED;
        }
        return switch (guildRole) {
            case GuildRole.OWNER -> com.mineplex.studio.dataplane.contracts.GuildRole.OWNER;
            case GuildRole.OFFICER -> com.mineplex.studio.dataplane.contracts.GuildRole.OFFICER;
            case GuildRole.MEMBER -> com.mineplex.studio.dataplane.contracts.GuildRole.MEMBER;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)guildRole));
        };
    }

    @Override
    public PlayerGuildInformation grpcPlayerGuildInformationToPlayerGuildInformation(com.mineplex.studio.dataplane.contracts.PlayerGuildInformation grpcPlayerGuildInformation) {
        ProtocolStringList protocolStringList3;
        ProtocolStringList protocolStringList2;
        ProtocolStringList protocolStringList1;
        ProtocolStringList protocolStringList;
        if (grpcPlayerGuildInformation == null) {
            return null;
        }
        PlayerGuildInformation.PlayerGuildInformationBuilder playerGuildInformation = PlayerGuildInformation.builder();
        if (grpcPlayerGuildInformation.hasPlayer()) {
            playerGuildInformation.player(this.profileGrpcMapper.grpcPlayerIdentitytoPlayerIdentity(grpcPlayerGuildInformation.getPlayer()));
        }
        if ((protocolStringList = grpcPlayerGuildInformation.getOwnedGuildIdsList()) != null) {
            playerGuildInformation.ownedGuildIds(new LinkedHashSet<String>(protocolStringList));
        }
        if ((protocolStringList1 = grpcPlayerGuildInformation.getJoinedGuildIdsList()) != null) {
            playerGuildInformation.joinedGuildIds(new LinkedHashSet<String>(protocolStringList1));
        }
        if ((protocolStringList2 = grpcPlayerGuildInformation.getInvitedGuildIdsList()) != null) {
            playerGuildInformation.invitedGuildIds(new LinkedHashSet<String>(protocolStringList2));
        }
        if ((protocolStringList3 = grpcPlayerGuildInformation.getJoinRequestedGuildIdsList()) != null) {
            playerGuildInformation.joinRequestedGuildIds(new LinkedHashSet<String>(protocolStringList3));
        }
        playerGuildInformation.maxOwnedGuilds(grpcPlayerGuildInformation.getMaxOwnedGuilds());
        playerGuildInformation.maxJoinedGuilds(grpcPlayerGuildInformation.getMaxJoinedGuilds());
        playerGuildInformation.maxTotalGuilds(grpcPlayerGuildInformation.getMaxTotalGuilds());
        return playerGuildInformation.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerGuildInformation playerGuildInformationToGrpcPlayerGuildInformation(PlayerGuildInformation playerGuildInformation) {
        if (playerGuildInformation == null) {
            return null;
        }
        PlayerGuildInformation.Builder playerGuildInformation1 = com.mineplex.studio.dataplane.contracts.PlayerGuildInformation.newBuilder();
        playerGuildInformation1.setPlayer(this.profileGrpcMapper.playerIdentityToGrpcPlayerIdentity(playerGuildInformation.getPlayer()));
        playerGuildInformation1.setMaxOwnedGuilds(playerGuildInformation.getMaxOwnedGuilds());
        playerGuildInformation1.setMaxJoinedGuilds(playerGuildInformation.getMaxJoinedGuilds());
        playerGuildInformation1.setMaxTotalGuilds(playerGuildInformation.getMaxTotalGuilds());
        if (playerGuildInformation.getOwnedGuildIds() != null) {
            for (String ownedGuildId : playerGuildInformation.getOwnedGuildIds()) {
                playerGuildInformation1.addOwnedGuildIds(ownedGuildId);
            }
        }
        if (playerGuildInformation.getJoinedGuildIds() != null) {
            for (String joinedGuildId : playerGuildInformation.getJoinedGuildIds()) {
                playerGuildInformation1.addJoinedGuildIds(joinedGuildId);
            }
        }
        if (playerGuildInformation.getInvitedGuildIds() != null) {
            for (String invitedGuildId : playerGuildInformation.getInvitedGuildIds()) {
                playerGuildInformation1.addInvitedGuildIds(invitedGuildId);
            }
        }
        if (playerGuildInformation.getJoinRequestedGuildIds() != null) {
            for (String joinRequestedGuildId : playerGuildInformation.getJoinRequestedGuildIds()) {
                playerGuildInformation1.addJoinRequestedGuildIds(joinRequestedGuildId);
            }
        }
        return playerGuildInformation1.build();
    }

    @Override
    public GuildMemberProperties grpcGuildPropertiesToGuildProperties(com.mineplex.studio.dataplane.contracts.GuildMemberProperties grpcGuildProperties) {
        if (grpcGuildProperties == null) {
            return null;
        }
        GuildMemberProperties.GuildMemberPropertiesBuilder guildMemberProperties = GuildMemberProperties.builder();
        guildMemberProperties.memberLimits(this.guildMemberLimitByRoleListToGuildMemberLimitByRoleList(grpcGuildProperties.getMemberLimitsList()));
        guildMemberProperties.maxMembers(grpcGuildProperties.getMaxMembers());
        return guildMemberProperties.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.GuildMemberProperties guildPropertiesToGrpcGuildProperties(GuildMemberProperties guildMemberProperties) {
        if (guildMemberProperties == null) {
            return null;
        }
        GuildMemberProperties.Builder guildMemberProperties1 = com.mineplex.studio.dataplane.contracts.GuildMemberProperties.newBuilder();
        guildMemberProperties1.setMaxMembers(guildMemberProperties.getMaxMembers());
        if (guildMemberProperties.getMemberLimits() != null) {
            for (GuildMemberProperties.GuildMemberLimitByRole memberLimit : guildMemberProperties.getMemberLimits()) {
                guildMemberProperties1.addMemberLimits(this.guildPropertiesMemberLimitToGrpcGuildMemberLimitByRole(memberLimit));
            }
        }
        return guildMemberProperties1.build();
    }

    @Override
    public GuildMemberLimitByRole guildPropertiesMemberLimitToGrpcGuildMemberLimitByRole(GuildMemberProperties.GuildMemberLimitByRole memberLimit) {
        if (memberLimit == null) {
            return null;
        }
        GuildMemberLimitByRole.Builder guildMemberLimitByRole = GuildMemberLimitByRole.newBuilder();
        guildMemberLimitByRole.setRole(this.guildRoleToGrpcGuildRole(memberLimit.getRole()));
        guildMemberLimitByRole.setMaxMembers(memberLimit.getMaxMembers());
        return guildMemberLimitByRole.build();
    }

    @Override
    public GuildMemberProperties.GuildMemberLimitByRole grpcGuildMemberLimitByRoleToGuildPropertiesMemberLimit(GuildMemberLimitByRole memberLimit) {
        if (memberLimit == null) {
            return null;
        }
        GuildMemberProperties.GuildMemberLimitByRole.GuildMemberLimitByRoleBuilder guildMemberLimitByRole = GuildMemberProperties.GuildMemberLimitByRole.builder();
        guildMemberLimitByRole.role(this.grpcGuildRoleToGuildRole(memberLimit.getRole()));
        guildMemberLimitByRole.maxMembers(memberLimit.getMaxMembers());
        return guildMemberLimitByRole.build();
    }

    @Override
    public MinimalGuild grpcGuildToMinimalGuild(com.mineplex.studio.dataplane.contracts.MinimalGuild grpcGuild) {
        if (grpcGuild == null) {
            return null;
        }
        MinimalGuild.MinimalGuildBuilder minimalGuild = MinimalGuild.builder();
        minimalGuild.id(grpcGuild.getId());
        minimalGuild.name(grpcGuild.getName());
        return minimalGuild.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.MinimalGuild minimalGuildToGrpcMinimalGuild(MinimalGuild minimalGuild) {
        if (minimalGuild == null) {
            return null;
        }
        MinimalGuild.Builder minimalGuild1 = com.mineplex.studio.dataplane.contracts.MinimalGuild.newBuilder();
        minimalGuild1.setId(minimalGuild.getId());
        minimalGuild1.setName(minimalGuild.getName());
        return minimalGuild1.build();
    }

    protected List<GuildMemberProperties.GuildMemberLimitByRole> guildMemberLimitByRoleListToGuildMemberLimitByRoleList(List<GuildMemberLimitByRole> list) {
        if (list == null) {
            return null;
        }
        ArrayList<GuildMemberProperties.GuildMemberLimitByRole> list1 = new ArrayList<GuildMemberProperties.GuildMemberLimitByRole>(list.size());
        for (GuildMemberLimitByRole guildMemberLimitByRole : list) {
            list1.add(this.grpcGuildMemberLimitByRoleToGuildPropertiesMemberLimit(guildMemberLimitByRole));
        }
        return list1;
    }
}

