/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.exception;

import com.mineplex.studio.dataplane.common.guild.exception.GuildException;
import com.mineplex.studio.dataplane.common.guild.model.MinimalGuild;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import lombok.Generated;
import lombok.NonNull;

public class AlreadyGuildOwnerException
extends GuildException {
    private static final long serialVersionUID = 3452198726451098234L;
    @NonNull
    private final PlayerIdentity player;
    @NonNull
    private final MinimalGuild guild;

    public AlreadyGuildOwnerException(@NonNull PlayerIdentity player, @NonNull MinimalGuild guild) {
        super("Player " + String.valueOf(player.getId()) + " is already the owner of guild: " + guild.getId());
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (guild == null) {
            throw new NullPointerException("guild is marked non-null but is null");
        }
        this.player = player;
        this.guild = guild;
    }

    @NonNull
    @Generated
    public PlayerIdentity getPlayer() {
        return this.player;
    }

    @NonNull
    @Generated
    public MinimalGuild getGuild() {
        return this.guild;
    }
}

